/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin;

import com.google.common.collect.Lists;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.Logger;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJson;
import java.beans.ConstructorProperties;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class PackageJsonCollector {
    private final Logger logger;

    public PackageJsonCollector(Logger logger) {
        this.logger = logger;
    }

    public List<PackageJson> collect(Params params) {
        FileSet fileSet = PackageJsonCollector.prepareFileSet(params);
        this.logger.debug("Using fileSet [%s] to collect the relevant package.json's.", PackageJsonCollector.asString(fileSet));
        String[] fileNames = new FileSetManager().getIncludedFiles(fileSet);
        List<PackageJson> files = Arrays.stream(fileNames).map(n -> PackageJsonCollector.packageJson(n, params)).collect(Collectors.toList());
        this.logger.debug("Collected the following package.json's: %s.", files);
        return files;
    }

    private static PackageJson packageJson(String packageJsonFilename, Params params) {
        return PackageJson.of(params.getBaseDir(), new File(params.getBaseDir(), packageJsonFilename));
    }

    private static FileSet prepareFileSet(Params params) {
        FileSet fileSet = new FileSet();
        fileSet.setFollowSymlinks(false);
        fileSet.setUseDefaultExcludes(false);
        fileSet.setDirectory(params.getBaseDir().getAbsolutePath());
        fileSet.setIncludes(PackageJsonCollector.asList(params.getIncludes()));
        fileSet.setExcludes(PackageJsonCollector.asList(params.getExcludes()));
        return fileSet;
    }

    private static List<String> asList(String[] elements) {
        return elements != null ? Arrays.asList(elements) : Lists.newArrayList();
    }

    private static String asString(FileSet fileSet) {
        return "FileSet(" + "directory=" + fileSet.getDirectory() + ", includes=" + fileSet.getIncludes() + ", excludes=" + fileSet.getExcludes() + ")";
    }

    public static final class Params {
        private final File baseDir;
        private final String[] includes;
        private final String[] excludes;

        public static Params of(File baseDir, String[] includes) {
            return Params.of(baseDir, includes, null);
        }

        @ConstructorProperties(value={"baseDir", "includes", "excludes"})
        @Generated
        private Params(File baseDir, String[] includes, String[] excludes) {
            this.baseDir = baseDir;
            this.includes = includes;
            this.excludes = excludes;
        }

        @Generated
        public static Params of(File baseDir, String[] includes, String[] excludes) {
            return new Params(baseDir, includes, excludes);
        }

        @Generated
        public File getBaseDir() {
            return this.baseDir;
        }

        @Generated
        public String[] getIncludes() {
            return this.includes;
        }

        @Generated
        public String[] getExcludes() {
            return this.excludes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Params)) {
                return false;
            }
            Params other = (Params)o;
            File this$baseDir = this.getBaseDir();
            File other$baseDir = other.getBaseDir();
            if (this$baseDir == null ? other$baseDir != null : !((Object)this$baseDir).equals(other$baseDir)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getIncludes(), other.getIncludes())) {
                return false;
            }
            return Arrays.deepEquals(this.getExcludes(), other.getExcludes());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $baseDir = this.getBaseDir();
            result = result * 59 + ($baseDir == null ? 43 : ((Object)$baseDir).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getIncludes());
            result = result * 59 + Arrays.deepHashCode(this.getExcludes());
            return result;
        }

        @Generated
        public String toString() {
            return "PackageJsonCollector.Params(baseDir=" + this.getBaseDir() + ", includes=" + Arrays.deepToString(this.getIncludes()) + ", excludes=" + Arrays.deepToString(this.getExcludes()) + ")";
        }
    }
}

