/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin;

import com.google.common.collect.Maps;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.Logger;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PomVersionEvaluator;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.RuntimePomVersionEvaluator;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.StaticPomVersionEvaluator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PomVersionEvaluatorFactory {
    private final Map<String, PomVersionEvaluator> evaluators;
    private final Logger logger;

    PomVersionEvaluatorFactory(Logger logger) {
        this.logger = logger;
        this.evaluators = this.initEvaluators();
    }

    public Optional<PomVersionEvaluator> create(String id) {
        PomVersionEvaluator evaluator = this.evaluators.get(id);
        this.logger.debug("Created an evaluator instance based on id '%s' [type: '%s].", id, evaluator != null ? evaluator.getClass().getName() : null);
        return Optional.ofNullable(evaluator);
    }

    public Set<String> getIds() {
        Set<String> ids = Collections.unmodifiableSet(this.evaluators.keySet());
        this.logger.debug("Returning ids %s to identify the available evaluator instances.", ids);
        return ids;
    }

    private Map<String, PomVersionEvaluator> initEvaluators() {
        HashMap evaluators = Maps.newHashMap();
        evaluators.put("runtime", new RuntimePomVersionEvaluator(this.logger));
        evaluators.put("static", new StaticPomVersionEvaluator(this.logger));
        return evaluators;
    }
}

