/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.Logger;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PomVersionEvaluator;
import java.beans.ConstructorProperties;
import java.io.File;
import lombok.Generated;
import org.apache.maven.project.MavenProject;

class StaticPomVersionEvaluator
implements PomVersionEvaluator {
    private static final XmlMapper xmlMapper = StaticPomVersionEvaluator.xmlMapper();
    private final Logger logger;

    @Override
    public String get(MavenProject mavenProject) {
        File file = new File(mavenProject.getBasedir(), "pom.xml");
        this.logger.debug("Reading the version from pom file '%s'...", file.getAbsolutePath());
        Project project = (Project)xmlMapper.readValue(file, Project.class);
        String version = project.getVersion();
        if (version == null) {
            this.logger.debug("Version of the projects pom file is not given, therefore falling back to the version of the parent...", new Object[0]);
            Project.Parent parent = project.getParent();
            version = parent != null ? parent.getVersion() : null;
        }
        this.logger.debug("Evaluated pom file version '%s' [in a static way].", version);
        return version;
    }

    private static XmlMapper xmlMapper() {
        return (XmlMapper)((XmlMapper.Builder)XmlMapper.builder().disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).build();
    }

    @ConstructorProperties(value={"logger"})
    @Generated
    public StaticPomVersionEvaluator(Logger logger) {
        this.logger = logger;
    }

    private static final class Project {
        private final Parent parent;
        private final String version;

        @ConstructorProperties(value={"parent", "version"})
        @Generated
        public Project(Parent parent, String version) {
            this.parent = parent;
            this.version = version;
        }

        @Generated
        public Parent getParent() {
            return this.parent;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Project)) {
                return false;
            }
            Project other = (Project)o;
            Parent this$parent = this.getParent();
            Parent other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Parent $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StaticPomVersionEvaluator.Project(parent=" + this.getParent() + ", version=" + this.getVersion() + ")";
        }

        private static final class Parent {
            private final String version;

            @ConstructorProperties(value={"version"})
            @Generated
            public Parent(String version) {
                this.version = version;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Parent)) {
                    return false;
                }
                Parent other = (Parent)o;
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "StaticPomVersionEvaluator.Project.Parent(version=" + this.getVersion() + ")";
            }
        }
    }
}

