/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin.check;

import de.ingogriebsch.maven.sync.packagejson.version.plugin.AbstractMojo;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJson;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.check.VersionValidator;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Singleton
@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, threadSafe=true)
class CheckMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "sync-packagejson-version.check.";
    private final VersionValidator versionValidator = new VersionValidator(this.logger);
    @Parameter(property="sync-packagejson-version.check.skip", alias="skipCheck", defaultValue="false")
    private boolean skip = false;
    @Parameter(property="sync-packagejson-version.check.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="sync-packagejson-version.check.includes", defaultValue="package.json,package-lock.json")
    private String[] includes;
    @Parameter(property="sync-packagejson-version.check.excludes")
    private String[] excludes;
    @Parameter(property="sync-packagejson-version.check.failIfNoneFound", defaultValue="true")
    private boolean failIfNoneFound = true;
    @Parameter(property="sync-packagejson-version.check.pomVersionEvaluation", defaultValue="runtime")
    private String pomVersionEvaluation;

    CheckMojo() {
    }

    @Override
    protected String getPomVersionEvaluation() {
        return this.pomVersionEvaluation;
    }

    @Override
    protected boolean isSkipped() {
        return this.skip;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.logger.info(String.format("Checking if the version of the package.json's found in this project are in sync with the version of the pom.xml [using '%s' evaluation]...", this.pomVersionEvaluation), new Object[0]);
        List<PackageJson> packageJsons = this.collectPackageJsons(this.includes, this.excludes);
        if (packageJsons.isEmpty()) {
            String msg = "No package.json's found in this project!";
            if (this.failIfNoneFound) {
                throw new MojoFailureException(msg);
            }
            this.logger.warn(msg, new Object[0]);
            return;
        }
        String pomVersion = this.evaluatePomVersion(this.project);
        List<VersionValidator.ConstraintViolation> violations = packageJsons.stream().map(pj -> this.versionValidator.validate(pomVersion, (PackageJson)pj, Charset.forName(this.encoding))).flatMap(Optional::stream).collect(Collectors.toList());
        if (!violations.isEmpty()) {
            this.output(violations);
            boolean singleViolation = violations.size() == 1;
            throw new MojoFailureException(String.format("%d package.json%s found in this project %s not in sync with the version of the pom.xml!", violations.size(), singleViolation ? "" : "'s", singleViolation ? "is" : "are"));
        }
        this.logger.info("Looks fine! :)", new Object[0]);
    }

    private void output(List<VersionValidator.ConstraintViolation> violations) {
        violations.forEach(v -> this.logger.error(v.toString(), new Object[0]));
    }
}

