/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin.check;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.Logger;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJson;
import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import java.util.Optional;
import lombok.Generated;

class VersionValidator {
    private static final ObjectMapper objectMapper = VersionValidator.objectMapper();
    private final Logger logger;

    VersionValidator(Logger logger) {
        this.logger = logger;
    }

    Optional<ConstraintViolation> validate(String pomVersion, PackageJson packageJson, Charset encoding) {
        String version = VersionValidator.read(packageJson).getVersion();
        this.logger.debug("Read version '%s' from '%s'.", version, packageJson);
        if (!version.equals(pomVersion)) {
            String name = packageJson.getName();
            this.logger.debug("Version '%s' of '%s' does not match against version '%s' of the pom.xml.", version, name, pomVersion);
            return Optional.of(ConstraintViolation.of(name, version, pomVersion));
        }
        return Optional.empty();
    }

    private static PackageJsonContent read(PackageJson packageJson) {
        return (PackageJsonContent)objectMapper.readValue(packageJson.getFile(), PackageJsonContent.class);
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return objectMapper;
    }

    private static class PackageJsonContent {
        private String version;

        @Generated
        public PackageJsonContent() {
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackageJsonContent)) {
                return false;
            }
            PackageJsonContent other = (PackageJsonContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PackageJsonContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "VersionValidator.PackageJsonContent(version=" + this.getVersion() + ")";
        }
    }

    static final class ConstraintViolation {
        private final String packageJsonName;
        private final String packageJsonVersion;
        private final String pomVersion;

        public String toString() {
            return "Version '" + this.packageJsonVersion + "' of '" + this.packageJsonName + "' is not in sync with version '" + this.pomVersion + "' of the pom.xml!";
        }

        @ConstructorProperties(value={"packageJsonName", "packageJsonVersion", "pomVersion"})
        @Generated
        private ConstraintViolation(String packageJsonName, String packageJsonVersion, String pomVersion) {
            this.packageJsonName = packageJsonName;
            this.packageJsonVersion = packageJsonVersion;
            this.pomVersion = pomVersion;
        }

        @Generated
        public static ConstraintViolation of(String packageJsonName, String packageJsonVersion, String pomVersion) {
            return new ConstraintViolation(packageJsonName, packageJsonVersion, pomVersion);
        }

        @Generated
        public String getPackageJsonName() {
            return this.packageJsonName;
        }

        @Generated
        public String getPackageJsonVersion() {
            return this.packageJsonVersion;
        }

        @Generated
        public String getPomVersion() {
            return this.pomVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConstraintViolation)) {
                return false;
            }
            ConstraintViolation other = (ConstraintViolation)o;
            String this$packageJsonName = this.getPackageJsonName();
            String other$packageJsonName = other.getPackageJsonName();
            if (this$packageJsonName == null ? other$packageJsonName != null : !this$packageJsonName.equals(other$packageJsonName)) {
                return false;
            }
            String this$packageJsonVersion = this.getPackageJsonVersion();
            String other$packageJsonVersion = other.getPackageJsonVersion();
            if (this$packageJsonVersion == null ? other$packageJsonVersion != null : !this$packageJsonVersion.equals(other$packageJsonVersion)) {
                return false;
            }
            String this$pomVersion = this.getPomVersion();
            String other$pomVersion = other.getPomVersion();
            return !(this$pomVersion == null ? other$pomVersion != null : !this$pomVersion.equals(other$pomVersion));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packageJsonName = this.getPackageJsonName();
            result = result * 59 + ($packageJsonName == null ? 43 : $packageJsonName.hashCode());
            String $packageJsonVersion = this.getPackageJsonVersion();
            result = result * 59 + ($packageJsonVersion == null ? 43 : $packageJsonVersion.hashCode());
            String $pomVersion = this.getPomVersion();
            result = result * 59 + ($pomVersion == null ? 43 : $pomVersion.hashCode());
            return result;
        }
    }
}

