/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin.sync;

import de.ingogriebsch.maven.sync.packagejson.version.plugin.AbstractMojo;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJson;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.sync.VersionWriter;
import java.nio.charset.Charset;
import java.util.List;
import javax.inject.Singleton;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Singleton
@Mojo(name="sync", requiresProject=true, requiresDirectInvocation=true)
class SyncMojo
extends AbstractMojo {
    private static final String PROPERTY_PREFIX = "sync-packagejson-version.sync.";
    private final VersionWriter versionWriter;
    @Parameter(property="sync-packagejson-version.sync.encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="sync-packagejson-version.sync.includes", defaultValue="package.json,package-lock.json")
    private String[] includes;
    @Parameter(property="sync-packagejson-version.sync.excludes")
    private String[] excludes;
    @Parameter(property="sync-packagejson-version.sync.pomVersionEvaluation", defaultValue="runtime")
    private String pomVersionEvaluation;

    SyncMojo() {
        this.versionWriter = new VersionWriter(this.logger);
    }

    @Override
    protected String getPomVersionEvaluation() {
        return this.pomVersionEvaluation;
    }

    @Override
    protected boolean isSkipped() {
        return false;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.logger.info(String.format("Synchronizing the version of the package.json's found in this project with the version of the pom.xml [using '%s' evaluation]...", this.pomVersionEvaluation), new Object[0]);
        List<PackageJson> packageJsons = this.collectPackageJsons(this.includes, this.excludes);
        if (packageJsons.isEmpty()) {
            throw new MojoFailureException("No package.json's found in this project!");
        }
        String pomVersion = this.evaluatePomVersion(this.project);
        packageJsons.stream().forEach(pj -> this.synchronize(pomVersion, (PackageJson)pj));
        this.logger.info("Done! :)", new Object[0]);
    }

    private void synchronize(String pomVersion, PackageJson packageJson) {
        this.versionWriter.write(pomVersion, packageJson, Charset.forName(this.encoding)).ifPresent(p -> this.logger.info("  " + p.toString(), new Object[0]));
    }
}

