/*
 * Decompiled with CFR 0.152.
 */
package de.ingogriebsch.maven.sync.packagejson.version.plugin.sync;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.Logger;
import de.ingogriebsch.maven.sync.packagejson.version.plugin.PackageJson;
import java.beans.ConstructorProperties;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.io.FileUtils;

class VersionWriter {
    private static final Pattern pattern = Pattern.compile("^.*?\"version\"\\s?:\\s?\"(.+?)\".*$", 32);
    private static final ObjectMapper objectMapper = VersionWriter.objectMapper();
    private final Logger logger;

    VersionWriter(Logger logger) {
        this.logger = logger;
    }

    Optional<Protocol> write(String pomVersion, PackageJson packageJson, Charset encoding) {
        String name = packageJson.getName();
        String version = VersionWriter.extractVersion(packageJson);
        if (version.equals(pomVersion)) {
            this.logger.debug("The version of '%s' is the same as of the pom.xml, therefore returning.", name);
            return Optional.empty();
        }
        File file = packageJson.getFile();
        String content = FileUtils.readFileToString((File)file, (Charset)encoding);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.matches() || matcher.groupCount() != 1) {
            this.logger.debug("No version found in '%s', therefore returning.", name);
            return Optional.empty();
        }
        this.logger.debug("Replacing the version in '%s' with version '%s'.", name, pomVersion);
        content = new StringBuilder(content).replace(matcher.start(1), matcher.end(1), pomVersion).toString();
        FileUtils.write((File)file, (CharSequence)content, (Charset)encoding, (boolean)false);
        return Optional.of(Protocol.of(name, pomVersion));
    }

    private static String extractVersion(PackageJson packageJson) {
        return ((PackageJsonContent)objectMapper.readValue(packageJson.getFile(), PackageJsonContent.class)).getVersion();
    }

    private static ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return objectMapper;
    }

    private static class PackageJsonContent {
        private String version;

        @Generated
        public PackageJsonContent() {
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackageJsonContent)) {
                return false;
            }
            PackageJsonContent other = (PackageJsonContent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PackageJsonContent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "VersionWriter.PackageJsonContent(version=" + this.getVersion() + ")";
        }
    }

    static final class Protocol {
        private final String packageJsonName;
        private final String pomVersion;

        public String toString() {
            return "Set the version in '" + this.packageJsonName + "' to '" + this.pomVersion + "'.";
        }

        @ConstructorProperties(value={"packageJsonName", "pomVersion"})
        @Generated
        private Protocol(String packageJsonName, String pomVersion) {
            this.packageJsonName = packageJsonName;
            this.pomVersion = pomVersion;
        }

        @Generated
        public static Protocol of(String packageJsonName, String pomVersion) {
            return new Protocol(packageJsonName, pomVersion);
        }

        @Generated
        public String getPackageJsonName() {
            return this.packageJsonName;
        }

        @Generated
        public String getPomVersion() {
            return this.pomVersion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Protocol)) {
                return false;
            }
            Protocol other = (Protocol)o;
            String this$packageJsonName = this.getPackageJsonName();
            String other$packageJsonName = other.getPackageJsonName();
            if (this$packageJsonName == null ? other$packageJsonName != null : !this$packageJsonName.equals(other$packageJsonName)) {
                return false;
            }
            String this$pomVersion = this.getPomVersion();
            String other$pomVersion = other.getPomVersion();
            return !(this$pomVersion == null ? other$pomVersion != null : !this$pomVersion.equals(other$pomVersion));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $packageJsonName = this.getPackageJsonName();
            result = result * 59 + ($packageJsonName == null ? 43 : $packageJsonName.hashCode());
            String $pomVersion = this.getPomVersion();
            result = result * 59 + ($pomVersion == null ? 43 : $pomVersion.hashCode());
            return result;
        }
    }
}

