/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.spring.view;

import de.neuland.jade4j.JadeConfiguration;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.exceptions.JadeException;
import de.neuland.jade4j.template.JadeTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.view.AbstractTemplateView;

public class JadeView
extends AbstractTemplateView {
    private String encoding;
    private JadeConfiguration configuration;
    private boolean renderExceptions = false;
    private String contentType;

    protected void renderMergedTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doRender(model, response);
    }

    private void doRender(Map<String, Object> model, HttpServletResponse response) throws IOException {
        this.logger.trace((Object)("Rendering Jade template [" + this.getUrl() + "] in JadeView '" + this.getBeanName() + "'"));
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        PrintWriter responseWriter = response.getWriter();
        if (this.renderExceptions) {
            StringWriter writer = new StringWriter();
            try {
                this.configuration.renderTemplate(this.getTemplate(), model, (Writer)writer);
                responseWriter.write(((Object)writer).toString());
            }
            catch (JadeException e) {
                String htmlString = e.toHtmlString(((Object)writer).toString());
                responseWriter.write(htmlString);
                this.logger.error((Object)("failed to render template [" + this.getUrl() + "]"), (Throwable)e);
            }
            catch (IOException e) {
                responseWriter.write("<pre>could not find template: " + this.getUrl() + "\n");
                e.printStackTrace(responseWriter);
                responseWriter.write("</pre>");
                this.logger.error((Object)"could not find template", (Throwable)e);
            }
        } else {
            try {
                this.configuration.renderTemplate(this.getTemplate(), model, (Writer)responseWriter);
            }
            catch (Throwable e) {
                this.logger.error((Object)("failed to render template [" + this.getUrl() + "]\n"), e);
            }
        }
    }

    protected JadeTemplate getTemplate() throws IOException, JadeException {
        return this.configuration.getTemplate(this.getUrl());
    }

    public boolean checkResource(Locale locale) throws Exception {
        return this.configuration.templateExists(this.getUrl());
    }

    protected void processTemplate(JadeTemplate template, Map<String, Object> model, HttpServletResponse response) throws IOException {
        try {
            this.configuration.renderTemplate(template, model, (Writer)response.getWriter());
        }
        catch (JadeCompilerException e) {
            e.printStackTrace();
        }
    }

    public JadeConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(JadeConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setRenderExceptions(boolean renderExceptions) {
        this.renderExceptions = renderExceptions;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

