/*
 * Decompiled with CFR 0.152.
 */
package de.redsix.pdfcompare;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageTools {
    public static final int EXCLUDED_BACKGROUND_RGB = new Color(255, 255, 100).getRGB();

    public static BufferedImage blankImage(BufferedImage image) {
        Graphics2D graphics = image.createGraphics();
        graphics.setPaint(Color.white);
        graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
        return image;
    }

    public static int fadeElement(int i) {
        Color color = new Color(i);
        return new Color(ImageTools.fade(color.getRed()), ImageTools.fade(color.getGreen()), ImageTools.fade(color.getBlue())).getRGB();
    }

    public static int fadeExclusion(int i) {
        Color color = new Color(i);
        if (color.getRed() > 245 && color.getGreen() > 245 && color.getBlue() > 245) {
            return EXCLUDED_BACKGROUND_RGB;
        }
        return ImageTools.fadeElement(i);
    }

    private static int fade(int i) {
        return i + (255 - i) * 3 / 5;
    }

    public static BufferedImage deepCopy(BufferedImage image) {
        return new BufferedImage(image.getColorModel(), image.copyData(null), image.getColorModel().isAlphaPremultiplied(), null);
    }
}

