/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.file;

import de.schlichtherle.truezip.fs.FsAbstractCompositeDriver;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.FsDriverProvider;
import de.schlichtherle.truezip.fs.FsScheme;
import de.schlichtherle.truezip.fs.sl.FsDriverLocator;
import de.schlichtherle.truezip.fs.spi.FsDriverService;
import de.schlichtherle.truezip.util.CanonicalStringSet;
import de.schlichtherle.truezip.util.HashMaps;
import de.schlichtherle.truezip.util.SuffixSet;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TArchiveDetector
extends FsAbstractCompositeDriver {
    public static final TArchiveDetector NULL = new TArchiveDetector("");
    public static final TArchiveDetector ALL = new TArchiveDetector(null);
    private final SuffixSet suffixes;
    private final Map<FsScheme, FsDriver> drivers;

    private static SuffixSet extensions(FsDriverProvider provider) {
        if (provider instanceof TArchiveDetector) {
            return new SuffixSet((Collection)((TArchiveDetector)provider).suffixes);
        }
        Map map = provider.get();
        SuffixSet set = new SuffixSet();
        for (Map.Entry entry : map.entrySet()) {
            if (!((FsDriver)entry.getValue()).isFederated()) continue;
            set.add(((FsScheme)entry.getKey()).toString());
        }
        return set;
    }

    public TArchiveDetector(@CheckForNull String suffixes) {
        this((FsDriverProvider)FsDriverLocator.SINGLETON, suffixes);
    }

    public TArchiveDetector(FsDriverProvider provider, @CheckForNull String suffixes) {
        SuffixSet accepted;
        SuffixSet available = TArchiveDetector.extensions(provider);
        if (null == suffixes) {
            accepted = available;
        } else {
            accepted = new SuffixSet(suffixes);
            if (accepted.retainAll((CanonicalStringSet)available)) {
                accepted = new SuffixSet(suffixes);
                accepted.removeAll((CanonicalStringSet)available);
                assert (!accepted.isEmpty());
                throw new IllegalArgumentException("\"" + accepted + "\" (no archive driver installed for these extensions)");
            }
        }
        this.suffixes = accepted;
        this.drivers = provider.get();
    }

    public TArchiveDetector(String suffixes, @CheckForNull FsDriver driver) {
        this((FsDriverProvider)NULL, suffixes, driver);
    }

    public TArchiveDetector(FsDriverProvider delegate, String suffixes, @CheckForNull FsDriver driver) {
        this(delegate, new Object[][]{{suffixes, driver}});
    }

    public TArchiveDetector(FsDriverProvider delegate, Object[][] config) {
        this(delegate, FsDriverService.newMap((Object[][])config));
    }

    public TArchiveDetector(FsDriverProvider provider, Map<FsScheme, FsDriver> config) {
        SuffixSet suffixes = TArchiveDetector.extensions(provider);
        Map available = provider.get();
        HashMap<FsScheme, FsDriver> drivers = new HashMap<FsScheme, FsDriver>(HashMaps.initialCapacity((int)(available.size() + config.size())));
        drivers.putAll(available);
        for (Map.Entry<FsScheme, FsDriver> entry : config.entrySet()) {
            FsScheme scheme = entry.getKey();
            FsDriver driver = entry.getValue();
            if (null != driver) {
                suffixes.add(scheme.toString());
                drivers.put(scheme, driver);
                continue;
            }
            suffixes.remove((Object)scheme.toString());
        }
        this.suffixes = suffixes;
        this.drivers = Collections.unmodifiableMap(drivers);
    }

    public Map<FsScheme, FsDriver> get() {
        return this.drivers;
    }

    @CheckForNull
    public FsScheme getScheme(String path) {
        path = path.replace('/', File.separatorChar);
        int i = path.lastIndexOf(File.separatorChar) + 1;
        path = path.substring(i);
        int l = path.length();
        i = 0;
        while (0 < (i = path.indexOf(46, i) + 1) && i < l) {
            String scheme = path.substring(i);
            if (!this.suffixes.contains((Object)scheme)) continue;
            try {
                return new FsScheme(scheme);
            }
            catch (URISyntaxException noSchemeNoArchiveBadLuck) {
            }
        }
        return null;
    }

    public String toString() {
        return this.suffixes.toString();
    }
}

