/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import de.siegmar.logbackgelf.GelfLayout;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

abstract class AbstractGelfAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final int DEFAULT_GELF_PORT = 12201;
    private String graylogHost;
    private int graylogPort = 12201;
    private GelfLayout layout;

    AbstractGelfAppender() {
    }

    public String getGraylogHost() {
        return this.graylogHost;
    }

    public void setGraylogHost(String graylogHost) {
        this.graylogHost = graylogHost;
    }

    public int getGraylogPort() {
        return this.graylogPort;
    }

    public void setGraylogPort(int graylogPort) {
        this.graylogPort = graylogPort;
    }

    public GelfLayout getLayout() {
        return this.layout;
    }

    public void setLayout(GelfLayout layout) {
        this.layout = layout;
    }

    public final void start() {
        if (this.graylogHost == null) {
            this.addError("No graylogHost configured");
            return;
        }
        if (this.layout == null) {
            this.layout = new GelfLayout();
            this.layout.setContext(this.getContext());
            this.layout.start();
        }
        try {
            this.startAppender();
            super.start();
        }
        catch (Exception e) {
            this.addError("Couldn't start appender", e);
        }
    }

    protected void startAppender() throws IOException {
    }

    protected void append(ILoggingEvent event) {
        String message = this.layout.doLayout(event);
        byte[] binMessage = message.getBytes(StandardCharsets.UTF_8);
        try {
            this.appendMessage(binMessage);
        }
        catch (Exception e) {
            this.addError("Error sending GELF message", e);
        }
    }

    protected abstract void appendMessage(byte[] var1) throws IOException;

    public void stop() {
        super.stop();
        try {
            this.close();
        }
        catch (IOException e) {
            this.addError("Couldn't close appender", e);
        }
    }

    protected abstract void close() throws IOException;
}

