/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.AbstractGelfAppender;
import de.siegmar.logbackgelf.GelfUdpChunker;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.zip.DeflaterOutputStream;

public class GelfUdpAppender
extends AbstractGelfAppender {
    private DatagramChannel channel;
    private Integer maxChunkSize;
    private boolean useCompression = true;
    private GelfUdpChunker chunker;

    public Integer getMaxChunkSize() {
        return this.maxChunkSize;
    }

    public void setMaxChunkSize(Integer maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }

    public boolean isUseCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    @Override
    protected void startAppender() throws IOException {
        this.channel = DatagramChannel.open();
        this.chunker = new GelfUdpChunker(this.maxChunkSize);
    }

    @Override
    protected void appendMessage(byte[] binMessage) throws IOException {
        byte[] messageToSend = this.useCompression ? GelfUdpAppender.compress(binMessage) : binMessage;
        InetSocketAddress remote = new InetSocketAddress(this.getGraylogHost(), this.getGraylogPort());
        for (ByteBuffer byteBuffer : this.chunker.chunks(messageToSend)) {
            while (byteBuffer.hasRemaining()) {
                this.channel.send(byteBuffer, remote);
            }
        }
    }

    private static byte[] compress(byte[] binMessage) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(binMessage.length);
        try (DeflaterOutputStream deflaterOut = new DeflaterOutputStream(bos);){
            ((OutputStream)deflaterOut).write(binMessage);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return bos.toByteArray();
    }

    @Override
    protected void close() throws IOException {
        this.channel.close();
    }
}

