/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

class SimpleJsonEncoder {
    private static final char QUOTE = '\"';
    private final StringBuilder sb = new StringBuilder(256);
    private boolean started;
    private boolean closed;

    SimpleJsonEncoder() {
        this.sb.append('{');
    }

    SimpleJsonEncoder appendToJSON(String key, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
        if (value != null) {
            this.appendKey(key);
            if (value instanceof Number) {
                this.sb.append(value.toString());
            } else {
                this.sb.append('\"').append(SimpleJsonEncoder.escapeString(value.toString())).append('\"');
            }
        }
        return this;
    }

    SimpleJsonEncoder appendToJSONUnquoted(String key, Object value) {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
        if (value != null) {
            this.appendKey(key);
            this.sb.append(value);
        }
        return this;
    }

    private void appendKey(String key) {
        if (this.started) {
            this.sb.append(',');
        } else {
            this.started = true;
        }
        this.sb.append('\"').append(SimpleJsonEncoder.escapeString(key)).append('\"').append(':');
    }

    private static String escapeString(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        block8: for (char ch : str.toCharArray()) {
            switch (ch) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(ch < ' ' ? SimpleJsonEncoder.escapeCharacter(ch) : Character.valueOf(ch));
                }
            }
        }
        return sb.toString();
    }

    private static String escapeCharacter(char ch) {
        String prefix = ch < '\u0010' ? "000" : (ch < '\u0100' ? "00" : (ch < '\u1000' ? "0" : ""));
        return "\\u" + prefix + Integer.toHexString(ch);
    }

    public String toString() {
        if (!this.closed) {
            this.sb.append('}');
            this.closed = true;
        }
        return this.sb.toString();
    }
}

