/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.serializers;

import com.fasterxml.jackson.databind.SerializerProvider;
import de.undercouch.bson4jackson.BsonGenerator;
import de.undercouch.bson4jackson.serializers.BsonSerializer;
import java.io.IOException;
import java.util.UUID;

public class BsonUuidSerializer
extends BsonSerializer<UUID> {
    @Override
    public void serialize(UUID value, BsonGenerator bgen, SerializerProvider provider) throws IOException {
        bgen.writeBinary(null, (byte)3, BsonUuidSerializer.uuidToLittleEndianBytes(value), 0, 16);
    }

    private static byte[] uuidToLittleEndianBytes(UUID uuid) {
        int i;
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        byte[] buffer = new byte[16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = (byte)(msb >>> 8 * i);
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = (byte)(lsb >>> 8 * (i - 16));
        }
        return buffer;
    }
}

