/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download;

import de.undercouch.gradle.tasks.download.DownloadSpec;
import de.undercouch.gradle.tasks.download.internal.ContentEncodingNoneInterceptor;
import de.undercouch.gradle.tasks.download.internal.InsecureHostnameVerifier;
import de.undercouch.gradle.tasks.download.internal.InsecureTrustManager;
import de.undercouch.gradle.tasks.download.internal.ProgressLoggerWrapper;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.gradle.api.Project;

public class DownloadAction
implements DownloadSpec {
    private static final HostnameVerifier INSECURE_HOSTNAME_VERIFIER = new InsecureHostnameVerifier();
    private static final TrustManager[] INSECURE_TRUST_MANAGERS = new TrustManager[]{new InsecureTrustManager()};
    private final Project project;
    private List<URL> sources = new ArrayList<URL>(1);
    private File dest;
    private boolean quiet = false;
    private boolean overwrite = true;
    private boolean onlyIfNewer = false;
    private boolean compress = true;
    private String username;
    private String password;
    private Map<String, String> headers;
    private boolean acceptAnyCertificate = false;
    private ProgressLoggerWrapper progressLogger;
    private String size;
    private long processedBytes = 0L;
    private long loggedKb = 0L;
    private int upToDate = 0;
    private int skipped = 0;
    private SSLConnectionSocketFactory insecureSSLSocketFactory = null;

    public DownloadAction(Project project) {
        this.project = project;
    }

    public void execute() throws IOException {
        if (this.sources.isEmpty()) {
            throw new IllegalArgumentException("Please provide a download source");
        }
        if (this.dest == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        if (this.dest.equals(this.project.getBuildDir())) {
            this.dest.mkdirs();
        }
        if (this.sources.size() > 1 && !this.dest.isDirectory()) {
            if (!this.dest.exists()) {
                this.dest.mkdirs();
            } else {
                throw new IllegalArgumentException("If multiple sources are provided the destination has to be a directory.");
            }
        }
        for (URL src : this.sources) {
            this.execute(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(URL src) throws IOException {
        long timestamp;
        File destFile = this.makeDestFile(src);
        if (!this.overwrite && destFile.exists()) {
            if (!this.quiet) {
                this.project.getLogger().info("Destination file already exists. Skipping '" + destFile.getName() + "'");
            }
            ++this.upToDate;
            return;
        }
        if (this.project.getGradle().getStartParameter().isOffline()) {
            if (destFile.exists()) {
                if (!this.quiet) {
                    this.project.getLogger().info("Skipping existing file '" + destFile.getName() + "' in offline mode.");
                }
                ++this.skipped;
                return;
            }
            throw new IllegalStateException("Unable to download " + src + " in offline mode.");
        }
        long l = timestamp = this.onlyIfNewer && destFile.exists() ? destFile.lastModified() : 0L;
        if (!this.quiet) {
            try {
                this.progressLogger = new ProgressLoggerWrapper(this.project, src.toString());
            }
            catch (Exception e) {
                this.project.getLogger().error("Unable to get progress logger. Download progress will not be displayed.");
            }
        }
        HttpHost httpHost = new HttpHost(src.getHost(), src.getPort(), src.getProtocol());
        CloseableHttpClient client = this.createHttpClient(httpHost);
        try {
            CloseableHttpResponse response = this.openConnection(httpHost, src.getFile(), timestamp, client);
            long lastModified = this.parseLastModified((HttpResponse)response);
            int code = response.getStatusLine().getStatusCode();
            if (code == 304 || lastModified != 0L && timestamp >= lastModified) {
                if (!this.quiet) {
                    this.project.getLogger().info("Not modified. Skipping '" + src + "'");
                }
                ++this.upToDate;
                return;
            }
            try {
                this.performDownload((HttpResponse)response, destFile);
            }
            finally {
                response.close();
            }
        }
        finally {
            client.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDownload(HttpResponse response, File destFile) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return;
        }
        long contentLength = entity.getContentLength();
        if (contentLength >= 0L) {
            this.size = this.toLengthText(contentLength);
        }
        this.processedBytes = 0L;
        this.loggedKb = 0L;
        InputStream is = entity.getContent();
        if (this.isContentCompressed(entity)) {
            is = new GZIPInputStream(is);
        }
        try {
            this.startProgress();
            FileOutputStream os = new FileOutputStream(destFile);
            boolean finished = false;
            try {
                int read;
                byte[] buf = new byte[10240];
                while ((read = is.read(buf)) >= 0) {
                    ((OutputStream)os).write(buf, 0, read);
                    this.processedBytes += (long)read;
                    this.logProgress();
                }
                os.flush();
                finished = true;
            }
            finally {
                ((OutputStream)os).close();
                if (!finished) {
                    destFile.delete();
                }
            }
        }
        finally {
            is.close();
            this.completeProgress();
        }
        long newTimestamp = this.parseLastModified(response);
        if (this.onlyIfNewer && newTimestamp > 0L) {
            destFile.setLastModified(newTimestamp);
        }
    }

    private File makeDestFile(URL src) {
        if (this.dest == null) {
            throw new IllegalArgumentException("Please provide a download destination");
        }
        File destFile = this.dest;
        if (destFile.isDirectory()) {
            String name = src.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            name = name.substring(name.lastIndexOf(47) + 1);
            destFile = new File(this.dest, name);
        } else {
            File parent = destFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
        }
        return destFile;
    }

    private HttpHost configureProxy(HttpHost httpHost) throws IOException {
        HttpHost proxy = null;
        String scheme = httpHost.getSchemeName();
        if (!("http".equals(scheme) || "https".equals(scheme) || "ftp".equals(scheme))) {
            return proxy;
        }
        String host = System.getProperty(scheme + ".proxyHost");
        if (host != null) {
            String portStr = System.getProperty(scheme + ".proxyPort");
            if (portStr != null) {
                int port;
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal proxy port: " + portStr);
                }
                proxy = new HttpHost(host, port);
            } else {
                proxy = new HttpHost(host);
            }
        }
        return proxy;
    }

    private CloseableHttpClient createHttpClient(HttpHost httpHost) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if ("https".equals(httpHost.getSchemeName()) && this.acceptAnyCertificate) {
            SSLConnectionSocketFactory icsf = this.getInsecureSSLSocketFactory();
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)icsf);
            Registry registry = RegistryBuilder.create().register("https", (Object)icsf).build();
            BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager((Lookup)registry);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        builder.addInterceptorFirst((HttpResponseInterceptor)new ContentEncodingNoneInterceptor());
        CloseableHttpClient client = builder.build();
        return client;
    }

    private CloseableHttpResponse openConnection(HttpHost httpHost, String file, long timestamp, CloseableHttpClient client) throws IOException {
        CloseableHttpResponse response;
        int code;
        HttpClientContext context = null;
        if (this.username != null && this.password != null) {
            context = HttpClientContext.create();
            this.addAuthentication(httpHost, this.username, this.password, true, context);
        }
        HttpGet get = new HttpGet(file);
        HttpHost proxy = this.configureProxy(httpHost);
        if (proxy != null) {
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            get.setConfig(config);
            String scheme = httpHost.getSchemeName();
            String proxyUser = System.getProperty(scheme + ".proxyUser");
            String proxyPassword = System.getProperty(scheme + ".proxyPassword");
            if (proxyUser != null && proxyPassword != null) {
                if (context == null) {
                    context = HttpClientContext.create();
                }
                this.addAuthentication(proxy, proxyUser, proxyPassword, false, context);
            }
        }
        if (timestamp > 0L) {
            get.setHeader("If-Modified-Since", DateUtils.formatDate((Date)new Date(timestamp)));
        }
        if (this.headers != null) {
            for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
                get.addHeader(headerEntry.getKey(), headerEntry.getValue());
            }
        }
        if (this.compress) {
            get.setHeader("Accept-Encoding", "gzip");
        }
        if (((code = (response = client.execute(httpHost, (HttpRequest)get, (HttpContext)context)).getStatusLine().getStatusCode()) < 200 || code > 299) && code != 304) {
            throw new ClientProtocolException(response.getStatusLine().getReasonPhrase());
        }
        return response;
    }

    private void addAuthentication(HttpHost host, String username, String password, boolean preAuthenticate, HttpClientContext context) {
        CredentialsProvider credsProvider;
        AuthCache authCache = context.getAuthCache();
        if (authCache == null) {
            authCache = new BasicAuthCache();
            context.setAuthCache(authCache);
        }
        if ((credsProvider = context.getCredentialsProvider()) == null) {
            credsProvider = new BasicCredentialsProvider();
            context.setCredentialsProvider(credsProvider);
        }
        credsProvider.setCredentials(new AuthScope(host), (Credentials)new UsernamePasswordCredentials(username, password));
        if (preAuthenticate) {
            authCache.put(host, (AuthScheme)new BasicScheme());
        }
    }

    private String toLengthText(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        if (bytes < 0x100000L) {
            return bytes / 1024L + " KB";
        }
        if (bytes < 0x40000000L) {
            return String.format("%.2f MB", (double)bytes / 1048576.0);
        }
        return String.format("%.2f GB", (double)bytes / 1.073741824E9);
    }

    private long parseLastModified(HttpResponse response) {
        Header header = response.getLastHeader("Last-Modified");
        if (header == null) {
            return 0L;
        }
        String value = header.getValue();
        if (value == null || value.isEmpty()) {
            return 0L;
        }
        Date date = DateUtils.parseDate((String)value);
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    private boolean isContentCompressed(HttpEntity entity) {
        Header header = entity.getContentEncoding();
        if (header == null) {
            return false;
        }
        String value = header.getValue();
        if (value == null || value.isEmpty()) {
            return false;
        }
        return value.equalsIgnoreCase("gzip");
    }

    private void startProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.started();
        }
    }

    private void completeProgress() {
        if (this.progressLogger != null) {
            this.progressLogger.completed();
        }
    }

    private void logProgress() {
        if (this.progressLogger == null) {
            return;
        }
        long processedKb = this.processedBytes / 1024L;
        if (processedKb > this.loggedKb) {
            String msg = this.toLengthText(this.processedBytes);
            if (this.size != null) {
                msg = msg + "/" + this.size;
            }
            msg = msg + " downloaded";
            this.progressLogger.progress(msg);
            this.loggedKb = processedKb;
        }
    }

    public boolean isUpToDate() {
        return this.upToDate == this.sources.size();
    }

    public boolean isSkipped() {
        return this.skipped == this.sources.size();
    }

    public List<File> getOutputFiles() {
        ArrayList<File> files = new ArrayList<File>(this.sources.size());
        for (URL src : this.sources) {
            files.add(this.makeDestFile(src));
        }
        return files;
    }

    @Override
    public void src(Object src) throws MalformedURLException {
        if (src instanceof Closure) {
            Closure closure = (Closure)src;
            src = closure.call();
        }
        if (src instanceof CharSequence) {
            this.sources.add(new URL(src.toString()));
        } else if (src instanceof URL) {
            this.sources.add((URL)src);
        } else if (src instanceof Collection) {
            Collection sc = (Collection)src;
            for (Object sco : sc) {
                this.src(sco);
            }
        } else if (src != null && src.getClass().isArray()) {
            int len = Array.getLength(src);
            for (int i = 0; i < len; ++i) {
                Object sco = Array.get(src, i);
                this.src(sco);
            }
        } else {
            throw new IllegalArgumentException("Download source must either be a URL, a CharSequence, a Collection or an array.");
        }
    }

    @Override
    public void dest(Object dest) {
        if (dest instanceof Closure) {
            Closure closure = (Closure)dest;
            dest = closure.call();
        }
        if (dest instanceof CharSequence) {
            this.dest = this.project.file((Object)dest.toString());
        } else if (dest instanceof File) {
            this.dest = (File)dest;
        } else {
            throw new IllegalArgumentException("Download destination must either be a File or a CharSequence");
        }
    }

    @Override
    public void quiet(boolean quiet) {
        this.quiet = quiet;
    }

    @Override
    public void overwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    @Override
    public void onlyIfNewer(boolean onlyIfNewer) {
        this.onlyIfNewer = onlyIfNewer;
    }

    @Override
    public void compress(boolean compress) {
        this.compress = compress;
    }

    @Override
    public void username(String username) {
        this.username = username;
    }

    @Override
    public void password(String password) {
        this.password = password;
    }

    @Override
    public void headers(Map<String, String> headers) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        } else {
            this.headers.clear();
        }
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    @Override
    public void header(String name, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(name, value);
    }

    @Override
    public void acceptAnyCertificate(boolean accept) {
        this.acceptAnyCertificate = accept;
    }

    @Override
    public Object getSrc() {
        if (this.sources.size() == 1) {
            return this.sources.get(0);
        }
        return this.sources;
    }

    @Override
    public File getDest() {
        return this.dest;
    }

    @Override
    public boolean isQuiet() {
        return this.quiet;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean isOnlyIfNewer() {
        return this.onlyIfNewer;
    }

    @Override
    public boolean isCompress() {
        return this.compress;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(name);
    }

    @Override
    public boolean isAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    private SSLConnectionSocketFactory getInsecureSSLSocketFactory() {
        if (this.insecureSSLSocketFactory == null) {
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, INSECURE_TRUST_MANAGERS, new SecureRandom());
                this.insecureSSLSocketFactory = new SSLConnectionSocketFactory(sc, INSECURE_HOSTNAME_VERIFIER);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
        return this.insecureSSLSocketFactory;
    }
}

