/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.filter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import javax.servlet.http.Part;

public class PartWrapper
implements Part {
    private Part part;
    private File file;
    private byte[] content;

    public PartWrapper(Part part, File file) {
        this.part = part;
        this.file = file;
    }

    public PartWrapper(Part part, byte[] content) {
        this.part = part;
        this.content = content;
    }

    public InputStream getInputStream() throws IOException {
        if (this.file == null) {
            return new ByteArrayInputStream(this.content);
        }
        return Files.newInputStream(Paths.get(this.file.getPath(), new String[0]), StandardOpenOption.DELETE_ON_CLOSE);
    }

    public String getContentType() {
        return this.part.getContentType();
    }

    public String getName() {
        return this.part.getName();
    }

    public long getSize() {
        return this.part.getSize();
    }

    public void write(String fileName) throws IOException {
        this.part.write(fileName);
    }

    public void delete() throws IOException {
        this.part.delete();
    }

    public String getHeader(String name) {
        return this.part.getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return this.part.getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return this.part.getHeaderNames();
    }

    public String getSubmittedFileName() {
        return this.part.getSubmittedFileName();
    }
}

