/*
 * Decompiled with CFR 0.152.
 */
package de.valtech.avs.core.mail;

import com.day.cq.mailer.MailService;
import de.valtech.avs.api.service.scanner.ScanResult;
import de.valtech.avs.core.mail.AvsNotificationMailerConfig;
import de.valtech.avs.core.mail.Html2TextConverter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AvsNotificationMailer.class})
@Designate(ocd=AvsNotificationMailerConfig.class)
public class AvsNotificationMailer {
    private static final Logger LOG = LoggerFactory.getLogger(AvsNotificationMailer.class);
    @Reference
    private MailService mailService;
    private AvsNotificationMailerConfig config;

    @Activate
    public void activate(AvsNotificationMailerConfig config) {
        this.config = config;
    }

    public void sendEmail(List<String> emails, String fileName, ScanResult result) {
        VelocityEngine ve = new VelocityEngine();
        ve.init();
        VelocityContext context = new VelocityContext();
        StringWriter writer = new StringWriter();
        if (fileName != null) {
            context.put("FILE_NAME", (Object)this.escape(fileName));
        }
        context.put("SCAN_OUTPUT", (Object)this.escape(result.getOutput()));
        ve.evaluate((Context)context, (Writer)writer, "AvsNotificationMailer", this.getBodyText());
        String body = writer.toString();
        String subject = this.getSubject();
        ArrayList<String> emailTO = new ArrayList<String>(emails);
        if (this.config.additionalRecipients() != null) {
            emailTO.addAll(Arrays.asList(this.config.additionalRecipients()));
        }
        try {
            this.sendMail(emailTO, subject, body);
        }
        catch (MessagingException | EmailException e) {
            LOG.error("Unable to send virus notification", e);
        }
    }

    private String escape(String input) {
        Html2TextConverter converter = new Html2TextConverter(input);
        return converter.getText();
    }

    private String getBodyText() {
        return this.config.body();
    }

    private String getSubject() {
        return this.config.subject();
    }

    private void sendMail(List<String> emails, String subject, String body) throws MessagingException, EmailException {
        MultiPartEmail email = new MultiPartEmail();
        MimeBodyPart messagePart = new MimeBodyPart();
        if (this.config.isHtml()) {
            messagePart.setContent((Object)body, "text/html; charset=utf-8");
        } else {
            messagePart.setContent((Object)body, "text/plain; charset=utf-8");
        }
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messagePart);
        email.setSubject(subject);
        for (String toAddress : emails) {
            email.addTo(toAddress);
        }
        email.setFrom(this.config.from());
        email.setContent(multipart);
        this.mailService.send((Object)email);
    }
}

