/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2Query;
import dev.equo.solstice.p2.P2Session;
import dev.equo.solstice.p2.P2Unit;
import dev.equo.solstice.p2.RepoStatus;
import dev.equo.solstice.p2.Table;
import dev.equo.solstice.p2.TableColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConsoleTable {
    public static String request(P2Model model, Format format) {
        NColumnTable table = new NColumnTable("kind", "value");
        for (String string : model.getP2repo()) {
            table.addRow("p2repo", string);
        }
        for (String string : model.getInstall()) {
            table.addRow("install", string);
        }
        for (Map.Entry entry : model.getFilters().entrySet()) {
            table.addRow("filter", (String)entry.getKey());
            for (String exclude : ((P2Model.Filter)entry.getValue()).getExclude()) {
                table.addRow("  exclude", exclude);
            }
            for (String excludePrefix : ((P2Model.Filter)entry.getValue()).getExcludePrefix()) {
                table.addRow("  excludePrefix", excludePrefix);
            }
            for (String excludeSuffix : ((P2Model.Filter)entry.getValue()).getExcludeSuffix()) {
                table.addRow("  excludeSuffix", excludeSuffix);
            }
            ((P2Model.Filter)entry.getValue()).getProps().forEach((key, value) -> table.addRow("  " + key, (String)value));
        }
        return table.toString(format);
    }

    public static String mavenStatus(Iterable<P2Unit> units, Format format) {
        ArrayList<RepoStatus> mavenStates = new ArrayList<RepoStatus>();
        for (P2Unit unit : units) {
            mavenStates.add(RepoStatus.forUnit(unit));
        }
        mavenStates.sort(Comparator.naturalOrder());
        if (mavenStates.isEmpty()) {
            return "No jars were specified.";
        }
        TableColumn.Data<RepoStatus> coordinate = new TableColumn("maven coordinate / p2 id").with(RepoStatus::coordinate);
        TableColumn.Data<RepoStatus> repo = new TableColumn("repo").with(RepoStatus::repo);
        return Table.getTable(format, mavenStates, coordinate, repo);
    }

    public static String nameAndDescription(Collection<P2Unit> units, Format format) {
        WordWrapTable table = new WordWrapTable();
        for (P2Unit unit : units) {
            String n = unit.properties.get("org.eclipse.equinox.p2.name");
            String name = n != null ? n : "(no org.eclipse.equinox.p2.name)";
            table.add(unit.id, name);
            String desc = unit.properties.get("org.eclipse.equinox.p2.description");
            if (desc == null) continue;
            table.add("", "  " + desc);
        }
        return table.toString("id", "name \\n description", format);
    }

    public static String ambiguousRequirements(P2Query query, Format format) {
        String firstLine = query.getAmbiguousRequirements().size() + " ambiguous requirement(s).";
        if (query.getAmbiguousRequirements().isEmpty()) {
            return firstLine;
        }
        NColumnTable table = new NColumnTable("ambiguous requirement", "candidate", "installed");
        for (P2Session.Requirement requirement : query.getAmbiguousRequirements()) {
            List<P2Unit> candidates = requirement.getProviders();
            for (int i = 0; i < candidates.size(); ++i) {
                P2Unit candidate = candidates.get(i);
                String firstCell = i == 0 ? requirement.toString() : "";
                table.addRow(firstCell, candidate.toString(), query.isInstalled(candidate) ? "[x]" : "[ ]");
            }
        }
        return firstLine + "\n" + table.toString(format);
    }

    public static String unmetRequirements(P2Query query, Format format) {
        String firstLine = query.getUnmetRequirements().size() + " unmet requirement(s).";
        if (query.getUnmetRequirements().isEmpty()) {
            return firstLine;
        }
        NColumnTable table = new NColumnTable("unmet requirement", "needed by");
        for (Map.Entry<P2Session.Requirement, Set<P2Unit>> unmet : query.getUnmetRequirements().entrySet()) {
            P2Unit neededByFirst = unmet.getValue().iterator().next();
            for (P2Unit neededBy : unmet.getValue()) {
                String firstCell = neededBy == neededByFirst ? unmet.getKey().toString() : "";
                table.addRow(firstCell, neededBy.toString());
            }
        }
        return firstLine + "\n" + table.toString(format);
    }

    public static String optionalRequirementsNotInstalled(P2Query query, Format format) {
        if (query.getOptionalRequirementsNotInstalled().isEmpty()) {
            return "Every optional requirement was installed.";
        }
        NColumnTable table = new NColumnTable("requirement (not installed)", "provided by", "optionally needed by");
        for (Map.Entry<P2Session.Requirement, Set<P2Unit>> unmet : query.getOptionalRequirementsNotInstalled().entrySet()) {
            P2Session.Requirement notInstalled = unmet.getKey();
            ArrayList<P2Unit> providedBy = new ArrayList<P2Unit>(notInstalled.getProviders());
            ArrayList neededBy = new ArrayList(unmet.getValue());
            for (int i = 0; i < Math.max(neededBy.size(), providedBy.size()); ++i) {
                String cell2;
                String cell0 = i == 0 ? notInstalled.getName() : "";
                String cell1 = i < providedBy.size() ? providedBy.get(i).toString() : "";
                String string = cell2 = i < neededBy.size() ? ((P2Unit)neededBy.get(i)).toString() : "";
                if (i == 0 && cell1.equals("")) {
                    cell1 = "-- none available --";
                }
                table.addRow(cell0, cell1, cell2);
            }
        }
        return table.toString(format);
    }

    public static String detail(Collection<P2Unit> units, Format format) {
        if (units.isEmpty()) {
            return "(none)";
        }
        WordWrapTable table = new WordWrapTable();
        P2Unit first = units.iterator().next();
        for (P2Unit unit : units) {
            if (unit != first) {
                table.add("---", "---");
            }
            table.add("id", unit.id);
            table.add("version", unit.version.toString());
            RepoStatus repoStatus = RepoStatus.forUnit(unit);
            table.add("maven coordinate", repoStatus.coordinate());
            table.add("maven repo", repoStatus.repo());
            if (unit.filter != null) {
                table.add("filter", unit.filter.toString());
            }
            for (Map.Entry<String, String> prop : unit.properties.entrySet()) {
                table.add("prop " + prop.getKey(), prop.getValue());
            }
            ArrayList<P2Session.Requirement> sortedOptionalsLast = new ArrayList<P2Session.Requirement>(unit.requires);
            sortedOptionalsLast.sort(Comparator.comparingInt(u -> u.isOptional() ? 1 : 0).thenComparing(Comparator.naturalOrder()));
            for (P2Session.Requirement req : sortedOptionalsLast) {
                String reqName;
                String string = reqName = req.isOptional() ? "req (opt) " : "req ";
                if (req.hasOnlyOneProvider()) {
                    table.add(reqName + req.getName(), req.getOnlyProvider().toString());
                    continue;
                }
                List<P2Unit> available = req.getProviders();
                table.add(reqName + req.getName(), available.size() + " available");
                for (P2Unit a : available) {
                    table.add("", a.toString());
                }
            }
        }
        return table.toString("key", "value", format);
    }

    private static class Pair {
        final String key;
        final String value;

        Pair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    static class WordWrapTable {
        private static final int MAX_VALUE_LEN = 50;
        final List<Pair> pairs = new ArrayList<Pair>();
        final String wrapIndent = "  ";

        WordWrapTable() {
        }

        public void add(String key, String value) {
            this.add(key, value, 50);
        }

        private void add(String key, String value, int maxLenFirstLine) {
            if ((value = value.replace("\n", " ").replace("\r", "")).length() <= maxLenFirstLine) {
                this.pairs.add(new Pair(key, value));
            } else {
                int maxLen = maxLenFirstLine - "  ".length();
                ArrayList<String> lines = new ArrayList<String>();
                int lineStart = 0;
                int i = 0;
                while (i + maxLen < value.length() && (i = value.lastIndexOf(32, i + maxLen)) != -1 && i >= lineStart) {
                    lines.add(value.substring(lineStart, i));
                    lineStart = ++i;
                }
                lines.add(value.substring(lineStart));
                this.pairs.add(new Pair(key, (String)lines.get(0)));
                for (i = 1; i < lines.size(); ++i) {
                    this.pairs.add(new Pair("", "  " + (String)lines.get(i)));
                }
            }
        }

        public String toString(String headerKey, String headerValue, Format format) {
            int maxLen = this.pairs.stream().mapToInt(p -> p.value.length()).max().getAsInt();
            if (maxLen > 50) {
                ArrayList<Pair> copy = new ArrayList<Pair>(this.pairs);
                this.pairs.clear();
                int i = 0;
                while (i < copy.size()) {
                    Pair pair2 = copy.get(i);
                    if (pair2.key.isEmpty()) {
                        this.pairs.remove(this.pairs.size() - 1);
                        Pair parent = copy.get(i - 1);
                        StringBuilder builder = new StringBuilder(parent.value);
                        while (i < copy.size() && copy.get((int)i).key.isEmpty()) {
                            builder.append(' ');
                            builder.append(copy.get((int)i).value);
                            ++i;
                        }
                        this.add(parent.key, builder.toString(), maxLen);
                        continue;
                    }
                    this.pairs.add(pair2);
                    ++i;
                }
            }
            TableColumn.Data<Pair> key = new TableColumn(headerKey).with(pair -> pair.key);
            TableColumn.Data<Pair> value = new TableColumn(headerValue).with(pair -> pair.value);
            return Table.getTable(format, this.pairs, key, value);
        }
    }

    static class NColumnTable {
        private static final int MAX_WIDTH = 80;
        private static final int MIN_SAVINGS = 1;
        private static final List<String> LEGEND = Arrays.asList("\u00a7\u00a7", "\u00a7", "\u00eb", "\u00e9", "\u00e1");
        private static final List<String> DICTIONARY = Arrays.asList("feature.feature.group", "feature.group", "org.eclipse.equinox", "org.eclipse", "org.apache");
        private final List<String> key = new ArrayList<String>();
        private final int ncol;
        private final TableColumn[] headers;
        private final List<String[]> rows = new ArrayList<String[]>();
        int widestWidth = -1;
        int widestRow = -1;

        public NColumnTable(String ... headers) {
            this.ncol = headers.length;
            this.headers = new TableColumn[this.ncol];
            for (int i = 0; i < this.ncol; ++i) {
                this.headers[i] = new TableColumn(headers[i]);
            }
        }

        public void addRow(String ... data) {
            if (data.length != this.ncol) {
                throw new IllegalArgumentException("Expected " + this.headers.length + " items but got " + data.length);
            }
            this.updateWidest(this.rows.size(), data);
            this.rows.add(data);
        }

        private void updateWidest(int row, String[] data) {
            int width = 1;
            for (String d : data) {
                width += d.length() + 3;
            }
            if (row != -1 && width > this.widestWidth) {
                this.widestWidth = width;
                this.widestRow = row;
            }
        }

        private void addKeyToLegend(String dict) {
            int idx = DICTIONARY.indexOf(dict);
            String legend = LEGEND.get(idx);
            this.key.add(dict);
            for (int r = 0; r < this.rows.size(); ++r) {
                String[] row = this.rows.get(r);
                for (int c = 0; c < this.ncol; ++c) {
                    String e = row[c];
                    if (!e.contains(dict)) continue;
                    row[c] = e.replace(dict, legend);
                }
            }
        }

        private void compress() {
            do {
                String[] row = this.rows.get(this.widestRow);
                String bestDict = null;
                int bestSavings = 1;
                for (String dict : DICTIONARY) {
                    int numOccurrences = 0;
                    for (int c = 0; c < this.ncol; ++c) {
                        if (!row[c].contains(dict)) continue;
                        ++numOccurrences;
                    }
                    int savings = numOccurrences * (dict.length() - 1);
                    if (savings <= bestSavings) continue;
                    bestDict = dict;
                    bestSavings = savings;
                }
                if (bestDict == null) {
                    return;
                }
                this.addKeyToLegend(bestDict);
            } while (this.key.size() < LEGEND.size() && this.recalculateWidestWidth() > 80);
        }

        private int recalculateWidestWidth() {
            this.widestWidth = -1;
            this.widestRow = -1;
            for (int r = 0; r < this.rows.size(); ++r) {
                this.updateWidest(r, this.rows.get(r));
            }
            return this.widestWidth;
        }

        public String toString(Format format) {
            if (format == Format.ascii && this.widestWidth > 80) {
                this.compress();
            }
            StringBuilder result = new StringBuilder(Table.getTable(format, this.headers, (String[][])this.rows.toArray((T[])new String[0][])));
            this.key.sort(Comparator.naturalOrder());
            for (String k : this.key) {
                result.append(LEGEND.get(DICTIONARY.indexOf(k))).append(" ").append(k).append("\n");
            }
            return result.toString();
        }
    }

    public static enum Format {
        ascii,
        csv;

    }
}

