/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.Unchecked;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class SerializableMisc {
    public static void toFile(Serializable obj, File file) {
        try {
            Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
            try (FileOutputStream fileStream = new FileOutputStream(file);
                 ObjectOutputStream objectStream = new ObjectOutputStream(fileStream);){
                objectStream.writeObject(obj);
            }
        }
        catch (IOException e) {
            throw Unchecked.wrap(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromFile(Class<T> clazz, File file) {
        try (FileInputStream fileStream = new FileInputStream(file);
             ObjectInputStream objectStream = new ObjectInputStream(fileStream);){
            Object obj = objectStream.readObject();
            if (!clazz.isInstance(obj)) throw new IllegalArgumentException("Expected " + clazz + " but was " + obj.getClass());
            Object object = obj;
            return (T)object;
        }
        catch (IOException | ClassNotFoundException e) {
            throw Unchecked.wrap(e);
        }
    }
}

