/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.gemfire.testcontainers;

import com.vmware.gemfire.testcontainers.AbstractGemFireContainer;
import com.vmware.gemfire.testcontainers.GemFireLocatorContainer;
import com.vmware.gemfire.testcontainers.GemFireProxyContainer;
import com.vmware.gemfire.testcontainers.GemFireServerContainer;
import com.vmware.gemfire.testcontainers.Gfsh;
import com.vmware.gemfire.testcontainers.MemberConfig;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.runner.Description;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FailureDetectingExternalResource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.images.builder.Transferable;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;

public class GemFireCluster
extends FailureDetectingExternalResource
implements Closeable {
    public static final String DEFAULT_IMAGE = System.getProperty("gemfire.image", "gemfire/gemfire:10");
    public static final String ALL_GLOB = "*";
    public static final String LOCATOR_GLOB = "locator-*";
    public static final String SERVER_GLOB = "server-*";
    static final int JMX_PORT = 1099;
    static final int HTTP_PORT = 7070;
    private static final int DEFAULT_LOCATOR_COUNT = 1;
    private static final int DEFAULT_SERVER_COUNT = 2;
    private final DockerImageName image;
    private final String suffix;
    private GemFireProxyContainer proxy;
    private final List<Integer> locatorPorts = new ArrayList<Integer>();
    private final List<Integer> locatorHttpPorts = new ArrayList<Integer>();
    private final List<Integer> serverPorts = new ArrayList<Integer>();
    private final List<MemberConfig> locatorConfigs = new ArrayList<MemberConfig>();
    private final List<MemberConfig> serverConfigs = new ArrayList<MemberConfig>();
    private Network network;
    private Runnable postDeployGfsh = () -> {};
    private Runnable configurePdxGfsh = () -> {};

    public GemFireCluster() {
        this(DEFAULT_IMAGE);
    }

    public GemFireCluster(String imageName) {
        this(DockerImageName.parse((String)imageName), 1, 2);
    }

    public GemFireCluster(int locatorCount, int serverCount) {
        this(DEFAULT_IMAGE, locatorCount, serverCount);
    }

    public GemFireCluster(String imageName, int locatorCount, int serverCount) {
        this(DockerImageName.parse((String)imageName), locatorCount, serverCount);
    }

    public GemFireCluster(DockerImageName image, int locatorCount, int serverCount) {
        int i;
        this.image = image;
        this.suffix = Base58.randomString((int)6);
        for (i = 0; i < locatorCount; ++i) {
            this.locatorConfigs.add(new MemberConfig("locator", i, this.suffix));
        }
        for (i = 0; i < serverCount; ++i) {
            this.serverConfigs.add(new MemberConfig("server", i, this.suffix));
        }
    }

    public void start() {
        this.network = Network.builder().createNetworkCmdModifier(it -> it.withName("gemfire-" + this.suffix)).build();
        this.proxy = new GemFireProxyContainer(this.locatorConfigs, this.serverConfigs);
        this.proxy.withNetwork(this.network);
        this.proxy.start();
        String locatorAddresses = this.locatorConfigs.stream().map(x -> String.format("%s[%d]", x.getHostname(), x.getPort())).collect(Collectors.joining(","));
        for (MemberConfig config : this.locatorConfigs) {
            GemFireLocatorContainer locator = new GemFireLocatorContainer(config, this.image, this.network, locatorAddresses);
            config.setContainer(locator);
            locator.start();
            this.locatorPorts.add(config.getPort());
            this.locatorHttpPorts.add(config.getProxyHttpPublicPort());
        }
        this.locatorConfigs.forEach(x -> x.getContainer().waitToStart());
        this.configurePdxGfsh.run();
        for (MemberConfig config : this.serverConfigs) {
            GemFireServerContainer server = new GemFireServerContainer(config, this.image, this.network, locatorAddresses);
            config.setContainer(server);
            server.start();
            this.serverPorts.add(config.getPort());
        }
        this.serverConfigs.forEach(x -> x.getContainer().waitToStart());
        this.postDeployGfsh.run();
    }

    protected void starting(Description description) {
        super.starting(description);
        this.start();
    }

    protected void finished(Description description) {
        super.finished(description);
        this.close();
    }

    @Override
    public void close() {
        this.stopProxy();
        this.serverConfigs.stream().map(MemberConfig::getContainer).filter(Objects::nonNull).forEach(GenericContainer::stop);
        this.locatorConfigs.stream().map(MemberConfig::getContainer).filter(Objects::nonNull).forEach(GenericContainer::stop);
    }

    public Map<String, AbstractGemFireContainer<?>> getContainers() {
        HashMap result = new HashMap();
        this.locatorConfigs.forEach(c -> result.put(c.getMemberName(), c.getContainer()));
        this.serverConfigs.forEach(c -> result.put(c.getMemberName(), c.getContainer()));
        return result;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void stopProxy() {
        if (this.proxy != null) {
            this.proxy.stop();
        }
    }

    public GemFireCluster withConfiguration(String memberGlob, Consumer<AbstractGemFireContainer<?>> config) {
        this.findMembers(memberGlob).forEach(member -> member.addConfig(config));
        return this;
    }

    public GemFireCluster withPreStart(String memberGlob, Consumer<AbstractGemFireContainer<?>> config) {
        this.findMembers(memberGlob).forEach(member -> member.addPreStart(config));
        return this;
    }

    public GemFireCluster withLogConsumer(String memberGlob, BiConsumer<String, String> consumer) {
        return this.withConfiguration(memberGlob, container -> {
            AbstractGemFireContainer cfr_ignored_0 = (AbstractGemFireContainer)container.withLogConsumer(new MemberLoggingConsumer(container.getMemberName(), consumer));
        });
    }

    public GemFireCluster withClasspath(String memberGlob, String ... classpaths) {
        return this.withConfiguration(memberGlob, container -> {
            for (int i = 0; i < classpaths.length; ++i) {
                container.addFileSystemBind(classpaths[i], "/classpath/" + i, BindMode.READ_ONLY);
            }
        });
    }

    public GemFireCluster withGemFireProperty(String memberGlob, String name, String value) {
        return this.withConfiguration(memberGlob, container -> container.addJvmArg(String.format("--J=-Dgemfire.%s=%s", name, value)));
    }

    public GemFireCluster withDebugPort(String memberGlob, int basePort) {
        AtomicInteger port = new AtomicInteger(basePort);
        return this.withConfiguration(memberGlob, container -> {
            int localPort = port.getAndIncrement();
            container.setPortBindings(Collections.singletonList(String.format("%d:%d", localPort, localPort)));
            container.addJvmArg("--J=-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=0.0.0.0:" + localPort);
            System.err.println("Waiting for debugger to connect on port " + localPort);
        });
    }

    public GemFireCluster withStartupTimeout(String memberGlob, int timeout) {
        return this.withConfiguration(memberGlob, container -> container.setStartupTimeout(timeout));
    }

    public GemFireCluster withHostnameForClients(String memberGlob, String hostnameForClients) {
        return this.withConfiguration(memberGlob, container -> container.setHostnameForClients(hostnameForClients));
    }

    public GemFireCluster acceptLicense() {
        return this.withConfiguration(ALL_GLOB, container -> container.addEnv("ACCEPT_TERMS", "y"));
    }

    public GemFireCluster withCacheXml(String memberGlob, String cacheXml) {
        byte[] rawBytes;
        try (InputStream is = this.getClass().getResourceAsStream(cacheXml);){
            if (is == null) {
                throw new RuntimeException("Unable to locate resource: " + cacheXml);
            }
            rawBytes = GemFireCluster.readAllBytes(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to read resource: " + cacheXml, e);
        }
        Transferable fileData = Transferable.of((String)new String(rawBytes));
        return this.withConfiguration(memberGlob, container -> {
            container.withCopyToContainer(fileData, "/cache.xml");
            container.addJvmArg("--J=-Dgemfire.cache-xml-file=/cache.xml");
        });
    }

    protected static byte[] readAllBytes(InputStream input) throws IOException {
        int readCount;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((readCount = input.read(buffer)) != -1) {
            baos.write(buffer, 0, readCount);
        }
        return baos.toByteArray();
    }

    private List<MemberConfig> findMembers(String memberGlob) {
        ArrayList<MemberConfig> result = new ArrayList<MemberConfig>();
        Pattern regex = GemFireCluster.globToRegex(memberGlob);
        for (MemberConfig member : this.locatorConfigs) {
            if (!regex.matcher(member.getMemberName()).matches()) continue;
            result.add(member);
        }
        for (MemberConfig member : this.serverConfigs) {
            if (!regex.matcher(member.getMemberName()).matches()) continue;
            result.add(member);
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("No members matching '" + memberGlob + "' found");
        }
        return result;
    }

    public static Pattern globToRegex(String glob) {
        return Pattern.compile("(?s)^\\Q" + glob.replace("\\E", "\\E\\\\E\\Q").replace(ALL_GLOB, "\\E.*\\Q").replace("?", "\\E.\\Q") + "\\E$");
    }

    public GemFireCluster withPdx(String pdxAutoSerializerRegex, boolean pdxReadSerialized) {
        this.configurePdxGfsh = () -> this.gfsh(true, String.format("configure pdx --disk-store=DEFAULT --read-serialized=%s --auto-serializable-classes=%s", pdxReadSerialized, pdxAutoSerializerRegex));
        return this;
    }

    public GemFireCluster withPorts(String memberGlob, int ... ports) {
        List<MemberConfig> members = this.findMembers(memberGlob);
        if (members.size() != ports.length) {
            throw new IllegalArgumentException(String.format("Found %d members but supplied %d ports. They must be the same.", members.size(), ports.length));
        }
        for (int i = 0; i < ports.length; ++i) {
            members.get(i).setPort(ports[i]);
        }
        return this;
    }

    public GemFireCluster withGfsh(boolean logOutput, String ... commands) {
        this.postDeployGfsh = () -> this.gfsh(logOutput, commands);
        return this;
    }

    public int getLocatorPort() {
        return this.locatorPorts.get(0);
    }

    public List<Integer> getLocatorPorts() {
        return this.locatorPorts;
    }

    public List<Integer> getServerPorts() {
        return this.serverPorts;
    }

    @Deprecated
    public List<Integer> getHttpPorts() {
        return this.locatorHttpPorts;
    }

    public List<Integer> getHttpPorts(String memberGlob) {
        return this.findMembers(memberGlob).stream().map(MemberConfig::getProxyHttpPublicPort).collect(Collectors.toList());
    }

    public Gfsh.Builder gfshBuilder() {
        return new Gfsh.Builder(this.locatorConfigs.get(0).getContainer());
    }

    public String gfsh(boolean logOutput, String ... commands) {
        return this.gfshBuilder().withLogging(logOutput).build().run(commands);
    }

    private static class MemberLoggingConsumer
    implements Consumer<OutputFrame> {
        private final BiConsumer<String, String> realConsumer;
        private final String memberName;

        MemberLoggingConsumer(String memberName, BiConsumer<String, String> realConsumer) {
            this.memberName = memberName;
            this.realConsumer = realConsumer;
        }

        @Override
        public void accept(OutputFrame outputFrame) {
            this.realConsumer.accept(this.memberName, outputFrame.getUtf8String());
        }
    }
}

