/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class ByteArrayModule
extends SimpleModule {
    public ByteArrayModule() {
        this.addSerializer(byte[].class, new ByteArraySerializer());
        this.addDeserializer(byte[].class, new ByteArrayDeSerializer());
    }

    private static class ByteArraySerializer
    extends JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            int[] arr = new int[value.length];
            for (int i = 0; i < value.length; ++i) {
                arr[i] = value[i];
            }
            jgen.writeArray(arr, 0, arr.length);
        }
    }

    private static class ByteArrayDeSerializer
    extends JsonDeserializer<byte[]> {
        private ByteArrayDeSerializer() {
        }

        public byte[] deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            return (byte[])new ObjectMapper().readValue(jp.getCodec().readTree(jp).toString(), byte[].class);
        }
    }
}

