/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.frontend;

import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.TaskGenerateOpenAPI;
import dev.hilla.frontend.AbstractTaskEndpointGenerator;
import dev.hilla.generator.OpenAPISpecGenerator;
import java.io.File;
import java.util.Collections;
import java.util.Objects;

public class TaskGenerateOpenAPIImpl
extends AbstractTaskEndpointGenerator
implements TaskGenerateOpenAPI {
    private final File javaSourceFolder;
    private final ClassLoader classLoader;
    private final File output;

    TaskGenerateOpenAPIImpl(File properties, File javaSourceFolder, ClassLoader classLoader, File output) {
        super(properties);
        Objects.requireNonNull(javaSourceFolder, "Source paths should not be null.");
        Objects.requireNonNull(output, "OpenAPI output file should not be null.");
        Objects.requireNonNull(classLoader, "ClassLoader should not be null.");
        this.javaSourceFolder = javaSourceFolder;
        this.classLoader = classLoader;
        this.output = output;
    }

    public void execute() throws ExecutionFailedException {
        OpenAPISpecGenerator openApiSpecGenerator = new OpenAPISpecGenerator(this.readApplicationProperties());
        openApiSpecGenerator.generateOpenApiSpec(Collections.singletonList(this.javaSourceFolder.toPath()), this.classLoader, this.output.toPath());
    }
}

