/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.generator;

import dev.hilla.generator.GeneratorUtils;
import dev.hilla.generator.OpenAPIConfiguration;
import dev.hilla.generator.OpenAPIObjectGenerator;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPISpecGenerator {
    public static final String APPLICATION_TITLE = "vaadin.connect.application.title";
    public static final String APPLICATION_API_VERSION = "vaadin.connect.api.version";
    public static final String SERVER = "vaadin.connect.server";
    public static final String SERVER_DESCRIPTION = "vaadin.connect.server.description";
    public static final String PREFIX = "vaadin.endpoint.prefix";
    public static final String DEFAULT_SERVER = "http://localhost:8080";
    public static final String DEFAULT_SERVER_DESCRIPTION = "Vaadin backend";
    public static final String DEFAULT_APPLICATION_TITLE = "Vaadin application";
    public static final String DEFAULT_APPLICATION_API_VERSION = "0.0.1";
    public static final String DEFAULT_PREFIX = "/connect";
    private static final Logger log = LoggerFactory.getLogger(OpenAPISpecGenerator.class);
    private final OpenAPIObjectGenerator generator = new OpenAPIObjectGenerator();

    public OpenAPISpecGenerator(Properties applicationProperties) {
        this.generator.setOpenApiConfiguration(this.extractOpenApiConfiguration(applicationProperties));
    }

    public void generateOpenApiSpec(Collection<Path> sourcesPaths, Path specOutputFile) {
        sourcesPaths.forEach(this.generator::addSourcePath);
        log.debug("Parsing java files from {}", sourcesPaths);
        OpenAPI openAPI = this.generator.generateOpenApi();
        try {
            if (openAPI.getPaths().size() > 0) {
                log.debug("writing file {}", (Object)specOutputFile);
                FileUtils.writeStringToFile((File)specOutputFile.toFile(), (String)Json.pretty((Object)openAPI), (Charset)StandardCharsets.UTF_8);
            } else {
                log.debug("There are no endpoints to generate.");
                FileUtils.deleteQuietly((File)specOutputFile.toFile());
            }
        }
        catch (IOException e) {
            String errorMessage = String.format("Error while writing OpenAPI json file at %s", specOutputFile.toString());
            log.error(errorMessage, (Object)specOutputFile, (Object)e);
        }
    }

    public void generateOpenApiSpec(Collection<Path> sourcesPaths, ClassLoader classLoader, Path specOutputFile) {
        this.generator.setTypeResolverClassLoader(classLoader);
        this.generateOpenApiSpec(sourcesPaths, specOutputFile);
    }

    private OpenAPIConfiguration extractOpenApiConfiguration(Properties applicationProperties) {
        String prefix = (String)applicationProperties.getOrDefault((Object)PREFIX, DEFAULT_PREFIX);
        String server = GeneratorUtils.removeEnd((String)applicationProperties.getOrDefault((Object)SERVER, DEFAULT_SERVER), "/");
        String serverDescription = (String)applicationProperties.getOrDefault((Object)SERVER_DESCRIPTION, DEFAULT_SERVER_DESCRIPTION);
        String applicationTitle = (String)applicationProperties.getOrDefault((Object)APPLICATION_TITLE, DEFAULT_APPLICATION_TITLE);
        String applicationApiVersion = (String)applicationProperties.getOrDefault((Object)APPLICATION_API_VERSION, DEFAULT_APPLICATION_API_VERSION);
        return new OpenAPIConfiguration(applicationTitle, applicationApiVersion, server + prefix, serverDescription);
    }
}

