/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.test.context.MergedContextConfiguration;

public class ContextIdGenerator {
    private static final AtomicLong contextCounter = new AtomicLong(0L);
    private static final ConcurrentHashMap<Integer, String> hashToIdMapping = new ConcurrentHashMap();

    public static String getContextId(MergedContextConfiguration configuration) {
        if (configuration == null) {
            return "context-unknown";
        }
        int hash = configuration.hashCode();
        return hashToIdMapping.computeIfAbsent(hash, h -> "context-" + contextCounter.getAndIncrement());
    }

    static long getCurrentCounter() {
        return contextCounter.get();
    }

    static void reset() {
        contextCounter.set(0L);
        hashToIdMapping.clear();
    }
}

