/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import digital.pragmatech.testing.optimization.ContextOptimizationOpportunity;
import java.util.List;

public class OptimizationStatistics {
    private final long totalContextCreationTimeMs;
    private final long potentialTimeSavingsMs;
    private final long wastedTimeMs;
    private final int totalContextsCreated;
    private final List<ContextOptimizationOpportunity> topOpportunities;

    public OptimizationStatistics(long totalContextCreationTimeMs, long potentialTimeSavingsMs, long wastedTimeMs, int totalContextsCreated, List<ContextOptimizationOpportunity> topOpportunities) {
        this.totalContextCreationTimeMs = totalContextCreationTimeMs;
        this.potentialTimeSavingsMs = potentialTimeSavingsMs;
        this.wastedTimeMs = wastedTimeMs;
        this.totalContextsCreated = totalContextsCreated;
        this.topOpportunities = topOpportunities;
    }

    public long getTotalContextCreationTimeMs() {
        return this.totalContextCreationTimeMs;
    }

    public long getPotentialTimeSavingsMs() {
        return this.potentialTimeSavingsMs;
    }

    public long getWastedTimeMs() {
        return this.wastedTimeMs;
    }

    public int getTotalContextsCreated() {
        return this.totalContextsCreated;
    }

    public List<ContextOptimizationOpportunity> getTopOpportunities() {
        return this.topOpportunities;
    }

    public double getPotentialTimeSavingsPercentage() {
        return this.totalContextCreationTimeMs > 0L ? (double)this.potentialTimeSavingsMs * 100.0 / (double)this.totalContextCreationTimeMs : 0.0;
    }
}

