/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.cache.ContextCacheUtils;

public class SpringContextCacheAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SpringContextCacheAccessor.class);

    public static ContextCache getContextCache(TestContext testContext) {
        try {
            Field cacheAwareContextLoaderDelegateField = testContext.getClass().getDeclaredField("cacheAwareContextLoaderDelegate");
            cacheAwareContextLoaderDelegateField.setAccessible(true);
            Object cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegateField.get(testContext);
            Field contextCacheField = cacheAwareContextLoaderDelegate.getClass().getDeclaredField("contextCache");
            contextCacheField.setAccessible(true);
            return (ContextCache)contextCacheField.get(cacheAwareContextLoaderDelegate);
        }
        catch (Exception e) {
            logger.warn("Failed to access ContextCache via reflection", (Throwable)e);
            return null;
        }
    }

    public static int getMaxCacheSize() {
        try {
            return ContextCacheUtils.retrieveMaxCacheSize();
        }
        catch (Exception e) {
            logger.debug("Could not retrieve max cache size", (Throwable)e);
            return 32;
        }
    }

    public static CacheStatistics getCacheStatistics(ContextCache contextCache) {
        if (contextCache == null) {
            return new CacheStatistics(0, 0, 0, SpringContextCacheAccessor.getMaxCacheSize(), Collections.emptyList());
        }
        try {
            int size = 0;
            int hitCount = 0;
            int missCount = 0;
            ArrayList<String> contextKeys = new ArrayList<String>();
            try {
                Method sizeMethod = contextCache.getClass().getMethod("size", new Class[0]);
                size = (Integer)sizeMethod.invoke((Object)contextCache, new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Could not get cache size", (Throwable)e);
            }
            try {
                Method getHitCountMethod = contextCache.getClass().getMethod("getHitCount", new Class[0]);
                hitCount = (Integer)getHitCountMethod.invoke((Object)contextCache, new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Could not get hit count (method may not exist)", (Throwable)e);
            }
            try {
                Method getMissCountMethod = contextCache.getClass().getMethod("getMissCount", new Class[0]);
                missCount = (Integer)getMissCountMethod.invoke((Object)contextCache, new Object[0]);
            }
            catch (Exception e) {
                logger.debug("Could not get miss count (method may not exist)", (Throwable)e);
            }
            try {
                Field contextMapField = contextCache.getClass().getDeclaredField("contextMap");
                contextMapField.setAccessible(true);
                Map contextMap = (Map)contextMapField.get(contextCache);
                for (Object key : contextMap.keySet()) {
                    contextKeys.add(key.toString());
                }
            }
            catch (Exception e) {
                logger.debug("Could not access context keys from cache", (Throwable)e);
            }
            return new CacheStatistics(size, hitCount, missCount, SpringContextCacheAccessor.getMaxCacheSize(), contextKeys);
        }
        catch (Exception e) {
            logger.warn("Failed to get cache statistics via reflection", (Throwable)e);
            return new CacheStatistics(0, 0, 0, SpringContextCacheAccessor.getMaxCacheSize(), Collections.emptyList());
        }
    }

    public record CacheStatistics(int size, int hitCount, int missCount, int maxSize, List<String> contextKeys) {
        private final List<String> contextKeys;

        public CacheStatistics(int size, int hitCount, int missCount, int maxSize, List<String> contextKeys) {
            this.size = size;
            this.hitCount = hitCount;
            this.missCount = missCount;
            this.maxSize = maxSize;
            this.contextKeys = new ArrayList<String>(contextKeys);
        }

        public double getHitRatio() {
            int totalAccess = this.hitCount + this.missCount;
            return totalAccess > 0 ? (double)this.hitCount / (double)totalAccess : 0.0;
        }

        public List<String> contextKeys() {
            return Collections.unmodifiableList(this.contextKeys);
        }

        @Override
        public String toString() {
            return String.format("CacheStatistics{size=%d, maxSize=%d, hitCount=%d, missCount=%d, hitRatio=%.2f%%}", this.size, this.maxSize, this.hitCount, this.missCount, this.getHitRatio() * 100.0);
        }
    }
}

