/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing;

import digital.pragmatech.testing.ContextCacheEntry;
import digital.pragmatech.testing.ContextCacheTracker;
import digital.pragmatech.testing.ContextProfileData;
import digital.pragmatech.testing.SpringContextCacheAccessor;
import digital.pragmatech.testing.TestExecutionTracker;
import digital.pragmatech.testing.TestStatus;
import digital.pragmatech.testing.TimingTrackingApplicationContextInitializer;
import digital.pragmatech.testing.diagnostic.ContextDiagnostic;
import digital.pragmatech.testing.reporting.html.TestExecutionReporter;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.NonNull;
import org.springframework.test.context.BootstrapUtils;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.cache.ContextCache;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class SpringTestProfilerListener
extends AbstractTestExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(SpringTestProfilerListener.class);
    private static final TestExecutionTracker executionTracker = new TestExecutionTracker();
    private static final ContextCacheTracker contextCacheTracker = new ContextCacheTracker();
    private static final TestExecutionReporter reporter = new TestExecutionReporter();
    private final Map<TestContext, String> testClassNames = new ConcurrentHashMap<TestContext, String>();
    private final Map<TestContext, Instant> methodStartTimes = new ConcurrentHashMap<TestContext, Instant>();
    private final Map<TestContext, Instant> contextLoadStartTimes = new ConcurrentHashMap<TestContext, Instant>();
    private static volatile boolean reportGenerated = false;
    private static volatile boolean shutdownHookRegistered = false;
    private static final AtomicReference<TestContext> lastTestContext = new AtomicReference();

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void beforeTestClass(@NonNull TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        String className = testClass.getName();
        logger.debug("Starting Spring Test Profiler for test class: {}", (Object)className);
        SpringTestProfilerListener.registerShutdownHook();
        if (executionTracker.getTotalTestClasses() == 0) {
            executionTracker.startTracking();
        }
        this.testClassNames.put(testContext, className);
        executionTracker.recordTestClassStart(className);
        lastTestContext.set(testContext);
        this.contextLoadStartTimes.put(testContext, Instant.now());
        TestContextBootstrapper bootstrapper = BootstrapUtils.resolveTestContextBootstrapper((Class)testClass);
        MergedContextConfiguration mergedConfig = bootstrapper.buildMergedContextConfiguration();
        int cacheKey = mergedConfig.hashCode();
        contextCacheTracker.recordTestClassForContext(mergedConfig, className);
        logger.info("Test class {} uses context cache key {}", (Object)className, (Object)cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareTestInstance(@NonNull TestContext testContext) throws Exception {
        String className = this.testClassNames.get(testContext);
        Instant contextLoadEndTime = Instant.now();
        if (className != null) {
            try {
                Optional<ContextCacheEntry> entry;
                Class testClass = testContext.getTestClass();
                TestContextBootstrapper bootstrapper = BootstrapUtils.resolveTestContextBootstrapper((Class)testClass);
                MergedContextConfiguration mergedConfig = bootstrapper.buildMergedContextConfiguration();
                int cacheKey = mergedConfig.hashCode();
                Instant contextLoadStartTime = this.contextLoadStartTimes.get(testContext);
                long contextLoadDurationMs = 0L;
                if (contextLoadStartTime != null) {
                    contextLoadDurationMs = Duration.between(contextLoadStartTime, contextLoadEndTime).toMillis();
                }
                ContextProfileData profileData = null;
                if (testContext.getApplicationContext() instanceof ConfigurableApplicationContext) {
                    profileData = TimingTrackingApplicationContextInitializer.getContextProfileData((ConfigurableApplicationContext)testContext.getApplicationContext());
                }
                if (profileData != null) {
                    logger.debug("Enhanced context profiling available for test class {} - Total time: {}ms, Memory: {}MB, Beans: {}", new Object[]{className, profileData.getTotalLoadTimeMs(), profileData.getMemoryUsedMB(), profileData.getBeanCreationMetrics() != null ? Long.valueOf(profileData.getBeanCreationMetrics().getTotalBeansCreated()) : "unknown"});
                }
                if ((entry = contextCacheTracker.getCacheEntry(mergedConfig)).isPresent() && entry.get().isCreated()) {
                    contextCacheTracker.recordContextCacheHit(mergedConfig);
                    logger.debug("Context cache hit for test class {} ({}ms)", (Object)className, (Object)contextLoadDurationMs);
                } else {
                    ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)testContext.getApplicationContext();
                    ContextDiagnostic contextDiagnostic = (ContextDiagnostic)configurableContext.getBeanProvider(ContextDiagnostic.class).getIfAvailable();
                    if (contextDiagnostic != null) {
                        contextCacheTracker.recordContextCreation(mergedConfig, contextLoadDurationMs, contextDiagnostic.heapMemoryUsedBytes(), contextDiagnostic.availableProcessors());
                    } else {
                        contextCacheTracker.recordContextCreation(mergedConfig, contextLoadDurationMs);
                    }
                    String[] beanNames = testContext.getApplicationContext().getBeanDefinitionNames();
                    contextCacheTracker.recordBeanDefinitions(mergedConfig, beanNames);
                    logger.debug("New context created for test class {} with {} bean definitions ({}ms)", new Object[]{className, beanNames.length, contextLoadDurationMs});
                }
            }
            catch (Exception e) {
                logger.warn("Failed to track context loading for test class {}: {}", (Object)className, (Object)e.getMessage());
            }
            finally {
                this.contextLoadStartTimes.remove(testContext);
            }
        }
    }

    public void afterTestClass(@NonNull TestContext testContext) throws Exception {
        String className = this.testClassNames.get(testContext);
        if (className != null) {
            executionTracker.recordTestClassEnd(className);
            logger.debug("Completed Spring Test Profiler for test class: {}", (Object)className);
        }
        this.testClassNames.remove(testContext);
    }

    public void beforeTestMethod(@NonNull TestContext testContext) throws Exception {
        String className = this.testClassNames.get(testContext);
        String methodName = testContext.getTestMethod().getName();
        if (className != null) {
            executionTracker.recordTestMethodStart(className, methodName);
            this.methodStartTimes.put(testContext, Instant.now());
            Optional<MergedContextConfiguration> config = contextCacheTracker.getContextForTestClass(className);
            if (config.isPresent()) {
                contextCacheTracker.recordTestMethodForContext(config.get(), className, methodName);
            }
        }
    }

    public void afterTestExecution(@NonNull TestContext testContext) throws Exception {
        String className = this.testClassNames.get(testContext);
        String methodName = testContext.getTestMethod().getName();
        if (className != null) {
            TestStatus status = this.determineTestStatus(testContext);
            executionTracker.recordTestMethodEnd(className, methodName, status);
            this.methodStartTimes.remove(testContext);
        }
    }

    private TestStatus determineTestStatus(TestContext testContext) {
        if (testContext.getTestException() != null) {
            Throwable exception = testContext.getTestException();
            if (exception.getClass().getSimpleName().contains("AssumptionViolated") || exception.getClass().getSimpleName().contains("TestAborted")) {
                return TestStatus.ABORTED;
            }
            return TestStatus.FAILED;
        }
        return TestStatus.PASSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void registerShutdownHook() {
        if (shutdownHookRegistered) return;
        Class<SpringTestProfilerListener> clazz = SpringTestProfilerListener.class;
        synchronized (SpringTestProfilerListener.class) {
            if (shutdownHookRegistered) return;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> SpringTestProfilerListener.generateReport(), "SpringTestProfilerReportGenerator"));
            shutdownHookRegistered = true;
            logger.debug("Registered shutdown hook for Spring Test Profiler report generation");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateReport() {
        Class<SpringTestProfilerListener> clazz = SpringTestProfilerListener.class;
        synchronized (SpringTestProfilerListener.class) {
            if (!reportGenerated) {
                logger.info("Generating Spring Test Profiler");
                executionTracker.stopTracking();
                SpringContextCacheAccessor.CacheStatistics springStats = SpringTestProfilerListener.getCacheStatistics();
                reporter.generateReport(executionTracker, springStats, contextCacheTracker);
                contextCacheTracker.clear();
                reportGenerated = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static ContextCache getContextCache() {
        TestContext context = lastTestContext.get();
        if (context != null) {
            return SpringContextCacheAccessor.getContextCache(context);
        }
        return null;
    }

    public static SpringContextCacheAccessor.CacheStatistics getCacheStatistics() {
        ContextCache cache = SpringTestProfilerListener.getContextCache();
        return SpringContextCacheAccessor.getCacheStatistics(cache);
    }
}

