/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing.reporting;

import digital.pragmatech.testing.TestStatus;
import java.time.Duration;
import java.time.Instant;

public class TestExecutionData {
    private final String testId;
    private final Instant startTime;
    private volatile Instant endTime;
    private volatile TestStatus status = TestStatus.RUNNING;
    private volatile Throwable throwable;
    private volatile String reason;

    public TestExecutionData(String testId, Instant startTime) {
        this.testId = testId;
        this.startTime = startTime;
    }

    public String getTestId() {
        return this.testId;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public synchronized void setEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    public Duration getDuration() {
        if (this.endTime != null) {
            return Duration.between(this.startTime, this.endTime);
        }
        return null;
    }

    public TestStatus getStatus() {
        return this.status;
    }

    public synchronized void setStatus(TestStatus status) {
        this.status = status;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public synchronized void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String getReason() {
        return this.reason;
    }

    public synchronized void setReason(String reason) {
        this.reason = reason;
    }

    public String getTestMethodName() {
        return this.testId.substring(this.testId.lastIndexOf(35) + 1);
    }

    public String getTestClassName() {
        return this.testId.substring(0, this.testId.lastIndexOf(35));
    }
}

