/*
 * Decompiled with CFR 0.152.
 */
package digital.pragmatech.testing.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionInfo {
    private static final Logger LOG = LoggerFactory.getLogger(VersionInfo.class);
    private static final String version = VersionInfo.loadVersion();

    private static String loadVersion() {
        String manifestVersion = VersionInfo.loadVersionFromManifest();
        if (manifestVersion != null && !manifestVersion.isEmpty()) {
            LOG.debug("Loaded version from MANIFEST.MF: {}", (Object)manifestVersion);
            return manifestVersion;
        }
        String propertiesVersion = VersionInfo.loadVersionFromProperties();
        if (propertiesVersion != null && !propertiesVersion.isEmpty()) {
            LOG.debug("Loaded version from properties file: {}", (Object)propertiesVersion);
            return propertiesVersion;
        }
        LOG.warn("Failed to load version information from MANIFEST.MF or properties file");
        return "unknown";
    }

    private static String loadVersionFromManifest() {
        try {
            String implementationVersion;
            Package pkg = VersionInfo.class.getPackage();
            if (pkg != null && (implementationVersion = pkg.getImplementationVersion()) != null && !implementationVersion.isEmpty()) {
                return implementationVersion;
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to load version from MANIFEST.MF", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadVersionFromProperties() {
        Properties props = new Properties();
        try (InputStream is = VersionInfo.class.getResourceAsStream("/spring-test-profiler-version.properties");){
            if (is == null) return null;
            props.load(is);
            String string = props.getProperty("version");
            return string;
        }
        catch (IOException e) {
            LOG.debug("Failed to load version from properties file", (Throwable)e);
        }
        return null;
    }

    public static String getVersion() {
        return version;
    }
}

