/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.binary;

import dk.dma.ais.binary.SixbitException;
import java.util.Arrays;

public class BinArray {
    private static final int[] INT_TO_SIX_BIT;
    private boolean[] bitSet = new boolean[1024];
    private int length;
    private int readPtr;

    private void ensureCapacity(int bitsRequired) {
        if (this.bitSet.length < bitsRequired) {
            int request = Math.max(2 * this.bitSet.length, bitsRequired);
            this.bitSet = Arrays.copyOf(this.bitSet, request);
        }
    }

    public void appendSixbit(String str, int padBits) throws SixbitException {
        if (str.length() == 0) {
            return;
        }
        int len = str.length() * 6 - padBits;
        int length = this.length;
        this.ensureCapacity(length + len);
        boolean[] bitSet = this.bitSet;
        int slen = str.length() - 1;
        for (int i = 0; i < slen; ++i) {
            char chr = str.charAt(i);
            int binVal = INT_TO_SIX_BIT[chr];
            if (binVal == -1) {
                throw new SixbitException("Illegal sixbit ascii char: " + chr);
            }
            bitSet[length] = (binVal & 0x20) > 0;
            bitSet[length + 1] = (binVal & 0x10) > 0;
            bitSet[length + 2] = (binVal & 8) > 0;
            bitSet[length + 3] = (binVal & 4) > 0;
            bitSet[length + 4] = (binVal & 2) > 0;
            bitSet[length + 5] = (binVal & 1) > 0;
            length += 6;
        }
        char chr = str.charAt(slen);
        int binVal = INT_TO_SIX_BIT[chr];
        if (binVal == -1) {
            throw new SixbitException("Illegal sixbit ascii char: " + chr);
        }
        int bits = 6 - padBits;
        switch (bits) {
            case 6: {
                bitSet[length + 5] = (binVal & 1) > 0;
            }
            case 5: {
                bitSet[length + 4] = (binVal & 2) > 0;
            }
            case 4: {
                bitSet[length + 3] = (binVal & 4) > 0;
            }
            case 3: {
                bitSet[length + 2] = (binVal & 8) > 0;
            }
            case 2: {
                bitSet[length + 1] = (binVal & 0x10) > 0;
            }
            case 1: {
                bitSet[length] = (binVal & 0x20) > 0;
            }
        }
        this.length = length + bits;
    }

    public void append(BinArray binArray) {
        int len = binArray.length;
        this.ensureCapacity(this.length + len);
        System.arraycopy(binArray.bitSet, 0, this.bitSet, this.length, len);
        this.length += len;
    }

    public void append(long val, int bits) {
        long powMask = 1L;
        this.ensureCapacity(this.length + bits);
        for (int i = this.length + bits - 1; i >= this.length; --i) {
            this.bitSet[i] = (val & powMask) > 0L;
            powMask <<= 1;
        }
        this.length += bits;
    }

    public String getString(int len) throws SixbitException {
        char[] resStr = new char[len];
        for (int i = 0; i < len; ++i) {
            resStr[i] = (char)BinArray.intToascii((char)this.getVal(6));
        }
        return new String(resStr);
    }

    public long getVal(int bits) throws SixbitException {
        int to = this.readPtr + bits - 1;
        long res = this.getVal(this.readPtr, to);
        this.readPtr = to + 1;
        return res;
    }

    public long getVal(int from, int to) throws SixbitException {
        if (to >= this.length) {
            throw new SixbitException(this.length + " is not enough bits. At least " + to + " expected.");
        }
        long val = 0L;
        long powMask = 1L;
        for (int i = to; i >= from; --i) {
            if (this.bitSet[i]) {
                val += powMask;
            }
            powMask <<= 1;
        }
        return val;
    }

    public int getLength() {
        return this.length;
    }

    public int getReadPtr() {
        return this.readPtr;
    }

    public int size() {
        return this.bitSet.length;
    }

    public boolean hasMoreBits() {
        return this.readPtr < this.length - 1;
    }

    public static int intToascii(int val) throws SixbitException {
        if (val > 63) {
            throw new SixbitException("Char value " + val + " not allowed");
        }
        if (val < 32) {
            return val + 64;
        }
        return val;
    }

    public static int intToSixbit(int val) throws SixbitException {
        if (val > 63) {
            throw new SixbitException("Char value " + val + " not allowed");
        }
        if (val < 40) {
            return val + 48;
        }
        return val + 56;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BinArray [TODO");
        builder.append("]");
        return builder.toString();
    }

    public void doneReading() {
        this.readPtr = 0;
    }

    static {
        int[] toSixbit = new int[65536];
        for (int chr = 0; chr < toSixbit.length; ++chr) {
            toSixbit[chr] = chr < 48 || chr > 119 || chr > 87 && chr < 96 ? -1 : (chr < 96 ? chr - 48 & 0x3F : chr - 56 & 0x3F);
        }
        INT_TO_SIX_BIT = toSixbit;
    }
}

