/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.binary;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitException;

public class SixbitEncoder {
    private BinArray binArray = new BinArray();
    private int padBits;

    public void addVal(long value, int bits) {
        this.binArray.append(value, bits);
    }

    public void addString(String str) {
        for (int i = 0; i < str.length(); ++i) {
            int c = str.charAt(i);
            if (c >= 64) {
                c -= 64;
            }
            this.addVal(c, 6);
        }
    }

    public void addString(String str, int length) {
        int i;
        for (i = 0; i < str.length() && i < length; ++i) {
            int c = str.charAt(i);
            if (c >= 64) {
                c -= 64;
            }
            this.addVal(c, 6);
        }
        while (i < length) {
            this.addVal(32L, 6);
            ++i;
        }
    }

    public void append(SixbitEncoder encoder) {
        this.binArray.append(encoder.binArray);
    }

    public void append(BinArray ba) {
        this.binArray.append(ba);
    }

    public String encode() throws SixbitException {
        StringBuilder buf = new StringBuilder();
        int start = 0;
        int stop = 0;
        while (start < this.binArray.getLength()) {
            stop = start + 6 - 1;
            if (stop >= this.binArray.getLength()) {
                this.padBits = stop - this.binArray.getLength() + 1;
                stop = this.binArray.getLength() - 1;
            }
            int data = (int)this.binArray.getVal(start, stop);
            int value = BinArray.intToSixbit(data <<= this.padBits);
            buf.append((char)value);
            start = stop + 1;
        }
        return buf.toString();
    }

    public int getPadBits() {
        return this.padBits;
    }

    public int getLength() {
        return this.binArray.getLength();
    }

    public BinArray getBinArray() {
        return this.binArray;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SixbitEncoder [binArray=");
        builder.append(this.binArray);
        builder.append(", padBits=");
        builder.append(this.padBits);
        builder.append("]");
        return builder.toString();
    }
}

