/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.binary.AisApplicationMessage;
import dk.dma.ais.sentence.Vdm;

public abstract class AisBinaryMessage
extends AisMessage {
    private static final long serialVersionUID = 1L;
    protected int spare;
    protected int dac;
    protected int fi;
    protected BinArray data;
    protected AisApplicationMessage appMessage;

    public AisBinaryMessage(int msgId) {
        super(msgId);
    }

    public AisBinaryMessage(Vdm vdm) {
        super(vdm);
    }

    public AisApplicationMessage getApplicationMessage() throws SixbitException {
        if (this.appMessage != null) {
            return this.appMessage;
        }
        this.appMessage = AisApplicationMessage.getInstance(this);
        return this.appMessage;
    }

    @Override
    protected SixbitEncoder encode() {
        SixbitEncoder encoder = super.encode();
        return encoder;
    }

    public SixbitEncoder getBinaryData() {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addVal(this.dac, 10);
        encoder.addVal(this.fi, 6);
        encoder.append(this.appMessage.getEncoded());
        return encoder;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public int getDac() {
        return this.dac;
    }

    public void setDac(int dac) {
        this.dac = dac;
    }

    public int getFi() {
        return this.fi;
    }

    public void setFi(int fi) {
        this.fi = fi;
    }

    public BinArray getData() {
        return this.data;
    }

    public void setData(BinArray data) {
        this.data = data;
    }

    public AisApplicationMessage getAppMessage() {
        return this.appMessage;
    }

    public void setAppMessage(AisApplicationMessage appMessage) {
        this.dac = appMessage.getDac();
        this.fi = appMessage.getFi();
        this.appMessage = appMessage;
    }

    public void setBinary(BinArray binArray) throws SixbitException {
        this.dac = (int)binArray.getVal(10);
        this.fi = (int)binArray.getVal(6);
        this.data = binArray;
        this.appMessage = AisApplicationMessage.getInstance(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", dac=");
        builder.append(this.dac);
        builder.append(", fi=");
        builder.append(this.fi);
        builder.append(", data=");
        builder.append(this.data);
        return builder.toString();
    }
}

