/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage1;
import dk.dma.ais.message.AisMessage10;
import dk.dma.ais.message.AisMessage11;
import dk.dma.ais.message.AisMessage12;
import dk.dma.ais.message.AisMessage13;
import dk.dma.ais.message.AisMessage14;
import dk.dma.ais.message.AisMessage17;
import dk.dma.ais.message.AisMessage18;
import dk.dma.ais.message.AisMessage19;
import dk.dma.ais.message.AisMessage2;
import dk.dma.ais.message.AisMessage21;
import dk.dma.ais.message.AisMessage24;
import dk.dma.ais.message.AisMessage27;
import dk.dma.ais.message.AisMessage3;
import dk.dma.ais.message.AisMessage4;
import dk.dma.ais.message.AisMessage5;
import dk.dma.ais.message.AisMessage6;
import dk.dma.ais.message.AisMessage7;
import dk.dma.ais.message.AisMessage8;
import dk.dma.ais.message.AisMessage9;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPositionMessage;
import dk.dma.ais.message.AisTargetType;
import dk.dma.ais.message.AisUnsupportedMessageType;
import dk.dma.ais.proprietary.IProprietarySourceTag;
import dk.dma.ais.proprietary.IProprietaryTag;
import dk.dma.ais.sentence.Vdm;
import dk.dma.enav.model.geometry.Position;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public abstract class AisMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Set<Integer> VALID_MESSAGE_TYPES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 13, 14, 17, 18, 19, 21, 24)));
    protected int msgId;
    protected int repeat;
    protected int userId;
    protected transient Vdm vdm;

    public AisMessage(int msgId) {
        this.msgId = msgId;
        this.repeat = 0;
    }

    public AisMessage(Vdm vdm) {
        this.vdm = vdm;
        this.msgId = vdm.getMsgId();
    }

    protected void parse(BinArray binArray) throws AisMessageException, SixbitException {
        this.repeat = (int)binArray.getVal(2);
        this.userId = (int)binArray.getVal(30);
    }

    protected SixbitEncoder encode() {
        SixbitEncoder encoder = new SixbitEncoder();
        encoder.addVal(this.msgId, 6);
        encoder.addVal(this.repeat, 2);
        encoder.addVal(this.userId, 30);
        return encoder;
    }

    public abstract SixbitEncoder getEncoded();

    public int getMsgId() {
        return this.msgId;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public void setRepeat(int repeat) {
        this.repeat = repeat;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public IProprietarySourceTag getSourceTag() {
        LinkedList<IProprietaryTag> tags;
        LinkedList<IProprietaryTag> linkedList = tags = this.vdm == null ? null : this.vdm.getTags();
        if (tags == null) {
            return null;
        }
        Iterator<IProprietaryTag> iterator = tags.descendingIterator();
        while (iterator.hasNext()) {
            IProprietaryTag tag = iterator.next();
            if (!(tag instanceof IProprietarySourceTag)) continue;
            return (IProprietarySourceTag)tag;
        }
        return null;
    }

    public LinkedList<IProprietaryTag> getTags() {
        return this.vdm.getTags();
    }

    public void setTag(IProprietaryTag tag) {
        LinkedList<IProprietaryTag> tags = this.vdm.getTags();
        if (tags == null) {
            tags = new LinkedList();
        }
        tags.addFirst(tag);
    }

    public void setTags(LinkedList<IProprietaryTag> tags) {
        this.vdm.setTags(tags);
    }

    public Vdm getVdm() {
        return this.vdm;
    }

    public Position getValidPosition() {
        return null;
    }

    public AisTargetType getTargetType() {
        if (this.userId >= 970000000 && this.userId <= 970999999) {
            return AisTargetType.SART;
        }
        Class<?> type = this.getClass();
        if (AisMessage4.class.isAssignableFrom(type)) {
            return AisTargetType.BS;
        }
        if (AisMessage21.class.isAssignableFrom(type)) {
            return AisTargetType.ATON;
        }
        if (AisMessage18.class.isAssignableFrom(type) || AisMessage19.class.isAssignableFrom(type) || AisMessage24.class.isAssignableFrom(type)) {
            return AisTargetType.B;
        }
        if (AisPositionMessage.class.isAssignableFrom(type) || AisMessage5.class.isAssignableFrom(type) || AisMessage27.class.isAssignableFrom(type)) {
            return AisTargetType.A;
        }
        return null;
    }

    public static AisMessage getInstance(Vdm vdm) throws AisMessageException, SixbitException {
        AisMessage message;
        switch (vdm.getMsgId()) {
            case 1: {
                message = new AisMessage1(vdm);
                vdm.getBinArray().doneReading();
                break;
            }
            case 2: {
                message = new AisMessage2(vdm);
                break;
            }
            case 3: {
                message = new AisMessage3(vdm);
                vdm.getBinArray().doneReading();
                break;
            }
            case 4: {
                message = new AisMessage4(vdm);
                break;
            }
            case 5: {
                message = new AisMessage5(vdm);
                break;
            }
            case 6: {
                message = new AisMessage6(vdm);
                break;
            }
            case 7: {
                message = new AisMessage7(vdm);
                break;
            }
            case 8: {
                message = new AisMessage8(vdm);
                break;
            }
            case 9: {
                message = new AisMessage9(vdm);
                break;
            }
            case 10: {
                message = new AisMessage10(vdm);
                break;
            }
            case 11: {
                message = new AisMessage11(vdm);
                break;
            }
            case 12: {
                message = new AisMessage12(vdm);
                break;
            }
            case 13: {
                message = new AisMessage13(vdm);
                break;
            }
            case 14: {
                message = new AisMessage14(vdm);
                break;
            }
            case 15: {
                message = new AisUnsupportedMessageType(vdm);
                break;
            }
            case 16: {
                message = new AisUnsupportedMessageType(vdm);
                break;
            }
            case 17: {
                message = new AisMessage17(vdm);
                break;
            }
            case 18: {
                message = new AisMessage18(vdm);
                break;
            }
            case 19: {
                message = new AisMessage19(vdm);
                break;
            }
            case 20: {
                message = new AisUnsupportedMessageType(vdm);
                break;
            }
            case 21: {
                message = new AisMessage21(vdm);
                break;
            }
            case 22: {
                message = new AisUnsupportedMessageType(vdm);
                break;
            }
            case 23: {
                message = new AisUnsupportedMessageType(vdm);
                break;
            }
            case 24: {
                message = new AisMessage24(vdm);
                break;
            }
            case 27: {
                message = new AisMessage27(vdm);
                break;
            }
            default: {
                throw new AisMessageException("Unknown AIS message id " + vdm.getMsgId());
            }
        }
        return message;
    }

    public static String trimText(String text) {
        if (text == null) {
            return null;
        }
        int firstAt = text.indexOf("@");
        if (firstAt >= 0) {
            text = text.substring(0, firstAt);
        }
        return text.trim();
    }

    public String reassemble() {
        LinkedList<IProprietaryTag> tags = this.vdm.getTags();
        StringBuilder buf = new StringBuilder();
        if (tags != null) {
            for (IProprietaryTag tag : tags) {
                if (tag.getSentence() == null) continue;
                buf.append(tag.getSentence() + "\r\n");
            }
        }
        buf.append(this.getVdm().getOrgLinesJoined());
        return buf.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[msgId=");
        builder.append(this.msgId);
        builder.append(", repeat=");
        builder.append(this.repeat);
        builder.append(", userId=");
        builder.append(this.userId);
        return builder.toString();
    }
}

