/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPositionMessage;
import dk.dma.ais.sentence.Vdm;

public class AisMessage1
extends AisPositionMessage {
    private static final long serialVersionUID = 1L;
    protected int slotTimeout;
    protected int subMessage;

    public AisMessage1() {
        super(1);
    }

    AisMessage1(int msgType) {
        super(msgType);
    }

    public AisMessage1(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        super.parse(binArray);
        this.slotTimeout = (int)binArray.getVal(3);
        this.subMessage = (int)binArray.getVal(14);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.slotTimeout, 3);
        encoder.addVal(this.subMessage, 14);
        return encoder;
    }

    public int getSlotTimeout() {
        return this.slotTimeout;
    }

    public void setSlotTimeout(int slotTimeout) {
        this.slotTimeout = slotTimeout;
    }

    public int getSubMessage() {
        return this.subMessage;
    }

    public void setSubMessage(int subMessage) {
        this.subMessage = subMessage;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", slotTimeout=");
        builder.append(this.slotTimeout);
        builder.append(", subMessage=");
        builder.append(this.subMessage);
        builder.append("]");
        return builder.toString();
    }
}

