/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage10
extends AisMessage {
    private static final long serialVersionUID = 1L;
    private int spare1;
    protected int destination;
    private int spare2;

    public AisMessage10() {
        super(10);
    }

    public AisMessage10(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse(vdm.getBinArray());
    }

    @Override
    public void parse(BinArray binArray) throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() != 72) {
            throw new AisMessageException("Message 10 wrong length " + sixbit.getLength());
        }
        super.parse(binArray);
        this.spare1 = (int)binArray.getVal(2);
        this.destination = (int)binArray.getVal(30);
        this.spare2 = (int)binArray.getVal(2);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spare1, 2);
        encoder.addVal(this.destination, 30);
        encoder.addVal(this.spare2, 2);
        return encoder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", spare1=");
        builder.append(this.spare1);
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append(", spare2=");
        builder.append(this.spare2);
        builder.append("]");
        return builder.toString();
    }

    public int getSpare1() {
        return this.spare1;
    }

    public void setSpare1(int spare1) {
        this.spare1 = spare1;
    }

    public int getDestination() {
        return this.destination;
    }

    public void setDestination(int destination) {
        this.destination = destination;
    }

    public int getSpare2() {
        return this.spare2;
    }

    public void setSpare2(int spare2) {
        this.spare2 = spare2;
    }
}

