/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage12
extends AisMessage {
    private static final long serialVersionUID = 1L;
    private int seqNum;
    private long destination;
    private int retransmit;
    private int spare;
    private String message;

    public AisMessage12() {
        super(12);
    }

    public AisMessage12(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() < 72 || binArray.getLength() > 1008) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + binArray.getLength());
        }
        super.parse(binArray);
        this.seqNum = (int)binArray.getVal(2);
        this.destination = binArray.getVal(30);
        this.retransmit = (int)binArray.getVal(1);
        this.spare = (int)binArray.getVal(1);
        this.message = binArray.getString((binArray.getLength() - 72) / 6);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.seqNum, 2);
        encoder.addVal(this.destination, 30);
        encoder.addVal(this.retransmit, 1);
        encoder.addVal(this.spare, 1);
        encoder.addString(this.message);
        return encoder;
    }

    public void setMessage(BinArray binArray) throws SixbitException {
        this.message = binArray.getString(binArray.getLength() / 6);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", retransmit=");
        builder.append(this.retransmit);
        builder.append(", seqNum=");
        builder.append(this.seqNum);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append("]");
        return builder.toString();
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    public long getDestination() {
        return this.destination;
    }

    public void setDestination(long destination) {
        this.destination = destination;
    }

    public int getRetransmit() {
        return this.retransmit;
    }

    public void setRetransmit(int retransmit) {
        this.retransmit = retransmit;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

