/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage14
extends AisMessage {
    private static final long serialVersionUID = 1L;
    private int spare;
    private String message;

    public AisMessage14() {
        super(14);
    }

    public AisMessage14(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() < 40 || binArray.getLength() > 1008) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + binArray.getLength());
        }
        super.parse(binArray);
        this.spare = (int)binArray.getVal(2);
        this.message = binArray.getString((binArray.getLength() - 40) / 6);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spare, 2);
        encoder.addString(this.message);
        return encoder;
    }

    public void setMessage(BinArray binArray) throws SixbitException {
        this.message = binArray.getString(binArray.getLength() / 6);
    }

    public int getSpare() {
        return this.spare;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", message=");
        builder.append(this.message);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append("]");
        return builder.toString();
    }
}

