/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage17
extends AisMessage {
    private static final long serialVersionUID = 1L;
    private int spare1;
    private int lon;
    private int lat;
    private int spare2;
    private int messageType;
    private int stationId;
    private int zCount;
    private int seqNum;
    private int dataWordCount;
    private int health;
    private int[] dataWords;

    public AisMessage17() {
        super(7);
    }

    public AisMessage17(int num) {
        super(num);
    }

    public AisMessage17(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() < 80 || sixbit.getLength() > 816) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + sixbit.getLength());
        }
        super.parse(sixbit);
        this.spare1 = (int)sixbit.getVal(2);
        this.lon = (int)sixbit.getVal(18);
        this.lat = (int)sixbit.getVal(17);
        this.spare2 = (int)sixbit.getVal(5);
        this.messageType = (int)sixbit.getVal(6);
        this.stationId = (int)sixbit.getVal(10);
        this.zCount = (int)sixbit.getVal(13);
        this.seqNum = (int)sixbit.getVal(3);
        this.dataWordCount = (int)sixbit.getVal(5);
        this.health = (int)sixbit.getVal(3);
        this.dataWords = new int[this.dataWordCount];
        for (int i = 0; i < this.dataWordCount && sixbit.hasMoreBits(); ++i) {
            this.dataWords[i] = (int)sixbit.getVal(24);
        }
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spare1, 2);
        encoder.addVal(this.lon, 18);
        encoder.addVal(this.lat, 17);
        encoder.addVal(this.spare2, 5);
        encoder.addVal(this.messageType, 6);
        encoder.addVal(this.stationId, 10);
        encoder.addVal(this.zCount, 13);
        encoder.addVal(this.seqNum, 3);
        encoder.addVal(this.dataWordCount, 5);
        encoder.addVal(this.health, 3);
        for (int dataWord : this.dataWords) {
            encoder.addVal(dataWord, 24);
        }
        return encoder;
    }

    public int getSpare1() {
        return this.spare1;
    }

    public void setSpare1(int spare1) {
        this.spare1 = spare1;
    }

    public int getLon() {
        return this.lon;
    }

    public void setLon(int lon) {
        this.lon = lon;
    }

    public int getLat() {
        return this.lat;
    }

    public void setLat(int lat) {
        this.lat = lat;
    }

    public int getSpare2() {
        return this.spare2;
    }

    public void setSpare2(int spare2) {
        this.spare2 = spare2;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public int getStationId() {
        return this.stationId;
    }

    public void setStationId(int stationId) {
        this.stationId = stationId;
    }

    public int getzCount() {
        return this.zCount;
    }

    public void setzCount(int zCount) {
        this.zCount = zCount;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    public int getDataWordCount() {
        return this.dataWordCount;
    }

    public void setDataWordCount(int dataWordCount) {
        this.dataWordCount = dataWordCount;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int health) {
        this.health = health;
    }

    public int[] getDataWords() {
        return this.dataWords;
    }

    public void setDataWords(int[] dataWords) {
        this.dataWords = dataWords;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", spare1=");
        builder.append(this.spare1);
        builder.append(", lon=");
        builder.append(this.lon);
        builder.append(", lat=");
        builder.append(this.lat);
        builder.append(", spare2=");
        builder.append(this.spare2);
        builder.append(", messageType=");
        builder.append(this.messageType);
        builder.append(", stationId=");
        builder.append(this.stationId);
        builder.append(", zCount=");
        builder.append(this.zCount);
        builder.append(", seqNum=");
        builder.append(this.seqNum);
        builder.append(", dataWordCount=");
        builder.append(this.dataWordCount);
        builder.append(", health=");
        builder.append(this.health);
        return builder.toString();
    }
}

