/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.IVesselPositionMessage;
import dk.dma.ais.sentence.Vdm;
import dk.dma.enav.model.geometry.Position;

public class AisMessage18
extends AisMessage
implements IVesselPositionMessage {
    private static final long serialVersionUID = 1L;
    private int spareAfterUserId;
    private int sog;
    private int posAcc;
    private AisPosition pos;
    private int cog;
    private int trueHeading;
    private int utcSec;
    private int spare;
    private int classBUnitFlag;
    private int classBDisplayFlag;
    private int classBDscFlag;
    private int classBBandFlag;
    private int classBMsg22Flag;
    private int modeFlag;
    private int raim;
    private int commStateSelectorFlag;
    private int commState;

    public AisMessage18() {
        super(18);
    }

    public AisMessage18(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() != 168) {
            throw new AisMessageException("Message 18 wrong length " + sixbit.getLength());
        }
        super.parse(sixbit);
        this.spareAfterUserId = (int)sixbit.getVal(8);
        this.sog = (int)sixbit.getVal(10);
        this.posAcc = (int)sixbit.getVal(1);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(sixbit.getVal(28));
        this.pos.setRawLatitude(sixbit.getVal(27));
        this.cog = (int)sixbit.getVal(12);
        this.trueHeading = (int)sixbit.getVal(9);
        this.utcSec = (int)sixbit.getVal(6);
        this.spare = (int)sixbit.getVal(2);
        this.classBUnitFlag = (int)sixbit.getVal(1);
        this.classBDisplayFlag = (int)sixbit.getVal(1);
        this.classBDscFlag = (int)sixbit.getVal(1);
        this.classBBandFlag = (int)sixbit.getVal(1);
        this.classBMsg22Flag = (int)sixbit.getVal(1);
        this.modeFlag = (int)sixbit.getVal(1);
        this.raim = (int)sixbit.getVal(1);
        this.commStateSelectorFlag = (int)sixbit.getVal(1);
        this.commState = (int)sixbit.getVal(19);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spareAfterUserId, 8);
        encoder.addVal(this.sog, 10);
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.pos.getRawLongitude(), 28);
        encoder.addVal(this.pos.getRawLatitude(), 27);
        encoder.addVal(this.cog, 12);
        encoder.addVal(this.trueHeading, 9);
        encoder.addVal(this.utcSec, 6);
        encoder.addVal(this.spare, 2);
        encoder.addVal(this.classBUnitFlag, 1);
        encoder.addVal(this.classBDisplayFlag, 1);
        encoder.addVal(this.classBDscFlag, 1);
        encoder.addVal(this.classBBandFlag, 1);
        encoder.addVal(this.classBMsg22Flag, 1);
        encoder.addVal(this.modeFlag, 1);
        encoder.addVal(this.raim, 1);
        encoder.addVal(this.commStateSelectorFlag, 1);
        encoder.addVal(this.commState, 19);
        return encoder;
    }

    public int getSpareAfterUserId() {
        return this.spareAfterUserId;
    }

    public void setSpareAfterUserId(int spareAfterUserId) {
        this.spareAfterUserId = spareAfterUserId;
    }

    @Override
    public int getSog() {
        return this.sog;
    }

    public void setSog(int sog) {
        this.sog = sog;
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    @Override
    public Position getValidPosition() {
        AisPosition pos = this.pos;
        return pos == null ? null : pos.getGeoLocation();
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    @Override
    public int getCog() {
        return this.cog;
    }

    public void setCog(int cog) {
        this.cog = cog;
    }

    @Override
    public int getTrueHeading() {
        return this.trueHeading;
    }

    public void setTrueHeading(int trueHeading) {
        this.trueHeading = trueHeading;
    }

    @Override
    public int getUtcSec() {
        return this.utcSec;
    }

    public void setUtcSec(int utcSec) {
        this.utcSec = utcSec;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public int getClassBUnitFlag() {
        return this.classBUnitFlag;
    }

    public void setClassBUnitFlag(int classBUnitFlag) {
        this.classBUnitFlag = classBUnitFlag;
    }

    public int getClassBDisplayFlag() {
        return this.classBDisplayFlag;
    }

    public void setClassBDisplayFlag(int classBDisplayFlag) {
        this.classBDisplayFlag = classBDisplayFlag;
    }

    public int getClassBDscFlag() {
        return this.classBDscFlag;
    }

    public void setClassBDscFlag(int classBDscFlag) {
        this.classBDscFlag = classBDscFlag;
    }

    public int getClassBBandFlag() {
        return this.classBBandFlag;
    }

    public void setClassBBandFlag(int classBBandFlag) {
        this.classBBandFlag = classBBandFlag;
    }

    public int getClassBMsg22Flag() {
        return this.classBMsg22Flag;
    }

    public void setClassBMsg22Flag(int classBMsg22Flag) {
        this.classBMsg22Flag = classBMsg22Flag;
    }

    public int getModeFlag() {
        return this.modeFlag;
    }

    public void setModeFlag(int modeFlag) {
        this.modeFlag = modeFlag;
    }

    @Override
    public int getRaim() {
        return this.raim;
    }

    public void setRaim(int raim) {
        this.raim = raim;
    }

    public int getCommStateSelectorFlag() {
        return this.commStateSelectorFlag;
    }

    public void setCommStateSelectorFlag(int commStateSelectorFlag) {
        this.commStateSelectorFlag = commStateSelectorFlag;
    }

    public int getCommState() {
        return this.commState;
    }

    public void setCommState(int commState) {
        this.commState = commState;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", classBBandFlag=");
        builder.append(this.classBBandFlag);
        builder.append(", classBDisplayFlag=");
        builder.append(this.classBDisplayFlag);
        builder.append(", classBDscFlag=");
        builder.append(this.classBDscFlag);
        builder.append(", classBMsg22Flag=");
        builder.append(this.classBMsg22Flag);
        builder.append(", classBUnitFlag=");
        builder.append(this.classBUnitFlag);
        builder.append(", cog=");
        builder.append(this.cog);
        builder.append(", commState=");
        builder.append(this.commState);
        builder.append(", commStateSelectorFlag=");
        builder.append(this.commStateSelectorFlag);
        builder.append(", modeFlag=");
        builder.append(this.modeFlag);
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", posAcc=");
        builder.append(this.posAcc);
        builder.append(", raim=");
        builder.append(this.raim);
        builder.append(", sog=");
        builder.append(this.sog);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", spareAfterUserId=");
        builder.append(this.spareAfterUserId);
        builder.append(", trueHeading=");
        builder.append(this.trueHeading);
        builder.append(", utcSec=");
        builder.append(this.utcSec);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isPositionValid() {
        return this.pos.getGeoLocation() != null;
    }

    @Override
    public boolean isCogValid() {
        return this.cog < 3600;
    }

    @Override
    public boolean isSogValid() {
        return this.sog < 1023;
    }

    @Override
    public boolean isHeadingValid() {
        return this.trueHeading < 360;
    }
}

