/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.AisStaticCommon;
import dk.dma.ais.message.IVesselPositionMessage;
import dk.dma.ais.sentence.Vdm;
import dk.dma.enav.model.geometry.Position;

public class AisMessage19
extends AisStaticCommon
implements IVesselPositionMessage {
    private static final long serialVersionUID = 1L;
    private int spare1;
    private int sog;
    private int posAcc;
    private AisPosition pos;
    private int cog;
    private int trueHeading;
    private int utcSec;
    private int spare2;
    private int posType;
    private int raimFlag;
    private int dte;
    private int modeFlag;
    private int spare3;

    public AisMessage19() {
        super(19);
    }

    public AisMessage19(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse(vdm.getBinArray());
    }

    @Override
    protected void parse(BinArray binArray) throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() != 312) {
            throw new AisMessageException("Message 19 wrong length " + sixbit.getLength());
        }
        super.parse(sixbit);
        this.spare1 = (int)sixbit.getVal(8);
        this.sog = (int)sixbit.getVal(10);
        this.posAcc = (int)sixbit.getVal(1);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(sixbit.getVal(28));
        this.pos.setRawLatitude(sixbit.getVal(27));
        this.cog = (int)sixbit.getVal(12);
        this.trueHeading = (int)sixbit.getVal(9);
        this.utcSec = (int)sixbit.getVal(6);
        this.spare2 = (int)sixbit.getVal(4);
        this.name = sixbit.getString(20);
        this.shipType = (int)sixbit.getVal(8);
        this.dimBow = (int)sixbit.getVal(9);
        this.dimStern = (int)sixbit.getVal(9);
        this.dimPort = (int)sixbit.getVal(6);
        this.dimStarboard = (int)sixbit.getVal(6);
        this.posType = (int)sixbit.getVal(4);
        this.raimFlag = (int)sixbit.getVal(1);
        this.dte = (int)sixbit.getVal(1);
        this.modeFlag = (int)sixbit.getVal(1);
        this.spare3 = (int)sixbit.getVal(4);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spare1, 8);
        encoder.addVal(this.sog, 10);
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.pos.getRawLongitude(), 28);
        encoder.addVal(this.pos.getRawLatitude(), 27);
        encoder.addVal(this.cog, 12);
        encoder.addVal(this.trueHeading, 9);
        encoder.addVal(this.utcSec, 6);
        encoder.addVal(this.spare2, 4);
        encoder.addString(this.name, 20);
        encoder.addVal(this.shipType, 8);
        encoder.addVal(this.dimBow, 9);
        encoder.addVal(this.dimStern, 9);
        encoder.addVal(this.dimPort, 6);
        encoder.addVal(this.dimStarboard, 6);
        encoder.addVal(this.posType, 4);
        encoder.addVal(this.raimFlag, 1);
        encoder.addVal(this.dte, 1);
        encoder.addVal(this.modeFlag, 1);
        encoder.addVal(this.spare3, 4);
        return encoder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", spare1=");
        builder.append(this.spare1);
        builder.append(", sog=");
        builder.append(this.sog);
        builder.append(", posAcc=");
        builder.append(this.posAcc);
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", cog=");
        builder.append(this.cog);
        builder.append(", trueHeading=");
        builder.append(this.trueHeading);
        builder.append(", utcSec=");
        builder.append(this.utcSec);
        builder.append(", spare2=");
        builder.append(this.spare2);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", shipType=");
        builder.append(this.shipType);
        builder.append(", dimBow=");
        builder.append(this.dimBow);
        builder.append(", dimStern=");
        builder.append(this.dimStern);
        builder.append(", dimPort=");
        builder.append(this.dimPort);
        builder.append(", dimStarboard=");
        builder.append(this.dimStarboard);
        builder.append(", posType=");
        builder.append(this.posType);
        builder.append(", raimFlag=");
        builder.append(this.raimFlag);
        builder.append(", dte=");
        builder.append(this.dte);
        builder.append(", modeFlag=");
        builder.append(this.modeFlag);
        builder.append(", spare3=");
        builder.append(this.spare3);
        builder.append("]");
        return builder.toString();
    }

    public int getSpare1() {
        return this.spare1;
    }

    public void setSpare1(int spare1) {
        this.spare1 = spare1;
    }

    @Override
    public int getSog() {
        return this.sog;
    }

    public void setSog(int sog) {
        this.sog = sog;
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    @Override
    public Position getValidPosition() {
        AisPosition pos = this.pos;
        return pos == null ? null : pos.getGeoLocation();
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    @Override
    public int getCog() {
        return this.cog;
    }

    public void setCog(int cog) {
        this.cog = cog;
    }

    @Override
    public int getTrueHeading() {
        return this.trueHeading;
    }

    public void setTrueHeading(int trueHeading) {
        this.trueHeading = trueHeading;
    }

    @Override
    public int getUtcSec() {
        return this.utcSec;
    }

    public void setUtcSec(int utcSec) {
        this.utcSec = utcSec;
    }

    public int getSpare2() {
        return this.spare2;
    }

    public void setSpare2(int spare2) {
        this.spare2 = spare2;
    }

    public int getPosType() {
        return this.posType;
    }

    public void setPosType(int posType) {
        this.posType = posType;
    }

    public int getRaimFlag() {
        return this.raimFlag;
    }

    public void setRaimFlag(int raimFlag) {
        this.raimFlag = raimFlag;
    }

    public int getDte() {
        return this.dte;
    }

    public void setDte(int dte) {
        this.dte = dte;
    }

    public int getModeFlag() {
        return this.modeFlag;
    }

    public void setModeFlag(int modeFlag) {
        this.modeFlag = modeFlag;
    }

    public int getSpare3() {
        return this.spare3;
    }

    public void setSpare3(int spare3) {
        this.spare3 = spare3;
    }

    @Override
    public boolean isPositionValid() {
        Position geo = this.pos.getGeoLocation();
        return geo != null;
    }

    @Override
    public boolean isCogValid() {
        return this.cog < 3600;
    }

    @Override
    public boolean isSogValid() {
        return this.sog < 1023;
    }

    @Override
    public boolean isHeadingValid() {
        return this.trueHeading < 360;
    }

    @Override
    public int getRaim() {
        return this.getRaimFlag();
    }
}

