/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.IDimensionMessage;
import dk.dma.ais.message.INameMessage;
import dk.dma.ais.message.IPositionMessage;
import dk.dma.ais.sentence.Vdm;
import dk.dma.enav.model.geometry.Position;

public class AisMessage21
extends AisMessage
implements IPositionMessage,
IDimensionMessage,
INameMessage {
    private static final long serialVersionUID = 1L;
    int atonType;
    String name;
    int posAcc;
    AisPosition pos;
    int dimBow;
    int dimStern;
    int dimPort;
    int dimStarboard;
    int posType;
    int utcSec;
    int offPosition;
    int regional;
    int raim;
    int virtual;
    int assigned;
    int spare1;
    String nameExt;
    int spare2;

    public AisMessage21() {
        super(21);
    }

    public AisMessage21(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() < 272 || binArray.getLength() > 360) {
            throw new AisMessageException("Message 21 wrong length " + binArray.getLength());
        }
        super.parse(binArray);
        this.atonType = (int)binArray.getVal(5);
        this.name = binArray.getString(20);
        this.posAcc = (int)binArray.getVal(1);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(binArray.getVal(28));
        this.pos.setRawLatitude(binArray.getVal(27));
        this.dimBow = (int)binArray.getVal(9);
        this.dimStern = (int)binArray.getVal(9);
        this.dimPort = (int)binArray.getVal(6);
        this.dimStarboard = (int)binArray.getVal(6);
        this.posType = (int)binArray.getVal(4);
        this.utcSec = (int)binArray.getVal(6);
        this.offPosition = (int)binArray.getVal(1);
        this.regional = (int)binArray.getVal(8);
        this.raim = (int)binArray.getVal(1);
        this.virtual = (int)binArray.getVal(1);
        this.assigned = (int)binArray.getVal(1);
        this.spare1 = (int)binArray.getVal(1);
        if (binArray.getLength() > 272) {
            this.nameExt = binArray.getString((binArray.getLength() - 272) / 6);
        }
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.atonType, 5);
        encoder.addString(this.name, 20);
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.pos.getRawLongitude(), 28);
        encoder.addVal(this.pos.getRawLatitude(), 27);
        encoder.addVal(this.dimBow, 9);
        encoder.addVal(this.dimStern, 9);
        encoder.addVal(this.dimPort, 6);
        encoder.addVal(this.dimStarboard, 6);
        encoder.addVal(this.posType, 4);
        encoder.addVal(this.utcSec, 6);
        encoder.addVal(this.offPosition, 1);
        encoder.addVal(this.regional, 8);
        encoder.addVal(this.raim, 1);
        encoder.addVal(this.virtual, 1);
        encoder.addVal(this.assigned, 1);
        encoder.addVal(this.spare1, 1);
        if (this.nameExt != null) {
            encoder.addString(this.nameExt, (this.vdm.getBinArray().getLength() - 272) / 6);
        }
        return encoder;
    }

    public int getAtonType() {
        return this.atonType;
    }

    public void setAtonType(int atonType) {
        this.atonType = atonType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    @Override
    public Position getValidPosition() {
        AisPosition pos = this.pos;
        return pos == null ? null : pos.getGeoLocation();
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    @Override
    public int getDimBow() {
        return this.dimBow;
    }

    public void setDimBow(int dimBow) {
        this.dimBow = dimBow;
    }

    @Override
    public int getDimStern() {
        return this.dimStern;
    }

    public void setDimStern(int dimStern) {
        this.dimStern = dimStern;
    }

    @Override
    public int getDimPort() {
        return this.dimPort;
    }

    public void setDimPort(int dimPort) {
        this.dimPort = dimPort;
    }

    @Override
    public int getDimStarboard() {
        return this.dimStarboard;
    }

    public void setDimStarboard(int dimStarboard) {
        this.dimStarboard = dimStarboard;
    }

    public int getPosType() {
        return this.posType;
    }

    public void setPosType(int posType) {
        this.posType = posType;
    }

    public int getUtcSec() {
        return this.utcSec;
    }

    public void setUtcSec(int utcSec) {
        this.utcSec = utcSec;
    }

    public int getOffPosition() {
        return this.offPosition;
    }

    public void setOffPosition(int offPosition) {
        this.offPosition = offPosition;
    }

    public int getRegional() {
        return this.regional;
    }

    public void setRegional(int regional) {
        this.regional = regional;
    }

    public int getRaim() {
        return this.raim;
    }

    public void setRaim(int raim) {
        this.raim = raim;
    }

    public int getVirtual() {
        return this.virtual;
    }

    public void setVirtual(int virtual) {
        this.virtual = virtual;
    }

    public int getAssigned() {
        return this.assigned;
    }

    public void setAssigned(int assigned) {
        this.assigned = assigned;
    }

    public int getSpare1() {
        return this.spare1;
    }

    public void setSpare1(int spare1) {
        this.spare1 = spare1;
    }

    public String getNameExt() {
        return this.nameExt;
    }

    public void setNameExt(String nameExt) {
        this.nameExt = nameExt;
    }

    public int getSpare2() {
        return this.spare2;
    }

    public void setSpare2(int spare2) {
        this.spare2 = spare2;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", assigned=");
        builder.append(this.assigned);
        builder.append(", atonType=");
        builder.append(this.atonType);
        builder.append(", dimBow=");
        builder.append(this.dimBow);
        builder.append(", dimPort=");
        builder.append(this.dimPort);
        builder.append(", dimStarboard=");
        builder.append(this.dimStarboard);
        builder.append(", dimStern=");
        builder.append(this.dimStern);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", nameExt=");
        builder.append(this.nameExt);
        builder.append(", offPosition=");
        builder.append(this.offPosition);
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", posAcc=");
        builder.append(this.posAcc);
        builder.append(", posType=");
        builder.append(this.posType);
        builder.append(", raim=");
        builder.append(this.raim);
        builder.append(", regional=");
        builder.append(this.regional);
        builder.append(", spare1=");
        builder.append(this.spare1);
        builder.append(", spare2=");
        builder.append(this.spare2);
        builder.append(", utcSec=");
        builder.append(this.utcSec);
        builder.append(", virtual=");
        builder.append(this.virtual);
        builder.append("]");
        return builder.toString();
    }
}

