/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisStaticCommon;
import dk.dma.ais.sentence.Vdm;

public class AisMessage24
extends AisStaticCommon {
    private static final long serialVersionUID = 1L;
    int partNumber;
    String vendorId;
    int posType;
    int spare;

    public AisMessage24() {
        super(24);
    }

    public AisMessage24(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() < 160) {
            throw new AisMessageException("Message 24 wrong length " + binArray.getLength());
        }
        super.parse(binArray);
        this.partNumber = (int)binArray.getVal(2);
        if (this.partNumber == 0) {
            this.name = binArray.getString(20);
            return;
        }
        if (binArray.getLength() < 168) {
            throw new AisMessageException("Message 24 (Part B) wrong length " + binArray.getLength());
        }
        this.shipType = (int)binArray.getVal(8);
        this.vendorId = binArray.getString(7);
        this.callsign = binArray.getString(7);
        this.dimBow = (int)binArray.getVal(9);
        this.dimStern = (int)binArray.getVal(9);
        this.dimPort = (int)binArray.getVal(6);
        this.dimStarboard = (int)binArray.getVal(6);
        this.posType = (int)binArray.getVal(4);
        this.spare = (int)binArray.getVal(2);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.partNumber, 2);
        if (this.partNumber == 0) {
            encoder.addString(this.name, 20);
            return encoder;
        }
        encoder.addVal(this.shipType, 8);
        encoder.addString(this.vendorId, 7);
        encoder.addString(this.callsign, 7);
        encoder.addVal(this.dimBow, 9);
        encoder.addVal(this.dimStern, 9);
        encoder.addVal(this.dimPort, 6);
        encoder.addVal(this.dimStarboard, 6);
        encoder.addVal(this.posType, 4);
        encoder.addVal(this.spare, 2);
        return encoder;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public String getVendorId() {
        return this.vendorId;
    }

    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    public int getPosType() {
        return this.posType;
    }

    public void setPosType(int posType) {
        this.posType = posType;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", partNumber=");
        builder.append(this.partNumber);
        builder.append(", callsign=");
        builder.append(this.callsign);
        builder.append(", dimBow=");
        builder.append(this.dimBow);
        builder.append(", dimPort=");
        builder.append(this.dimPort);
        builder.append(", dimStarboard=");
        builder.append(this.dimStarboard);
        builder.append(", dimStern=");
        builder.append(this.dimStern);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", shipType=");
        builder.append(this.shipType);
        builder.append(", posType=");
        builder.append(this.posType);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append("]");
        return builder.toString();
    }
}

