/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.IPositionMessage;
import dk.dma.ais.sentence.Vdm;

public class AisMessage27
extends AisMessage
implements IPositionMessage {
    private static final long serialVersionUID = 1L;
    private int posAcc;
    private int raim;
    private int navStatus;
    private AisPosition pos;
    private int sog;
    private int cog;
    private int gnssPosStatus;
    private int spare;

    public AisMessage27() {
        super(27);
    }

    public AisMessage27(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() != 96) {
            throw new AisMessageException("Message 27 wrong length " + binArray.getLength());
        }
        super.parse(binArray);
        this.posAcc = (int)binArray.getVal(1);
        this.raim = (int)binArray.getVal(1);
        this.navStatus = (int)binArray.getVal(4);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(binArray.getVal(18));
        this.pos.setRawLatitude(binArray.getVal(17));
        this.pos.set1817();
        this.sog = (int)binArray.getVal(6);
        this.cog = (int)binArray.getVal(9);
        this.gnssPosStatus = (int)binArray.getVal(1);
        this.spare = (int)binArray.getVal(1);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.raim, 1);
        encoder.addVal(this.navStatus, 4);
        encoder.addVal(this.pos.getRawLongitude(), 18);
        encoder.addVal(this.pos.getRawLatitude(), 17);
        encoder.addVal(this.sog, 6);
        encoder.addVal(this.cog, 9);
        encoder.addVal(this.gnssPosStatus, 1);
        encoder.addVal(this.spare, 1);
        return encoder;
    }

    public static long getSerialVersionUID() {
        return 1L;
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    public int getRaim() {
        return this.raim;
    }

    public void setRaim(int raim) {
        this.raim = raim;
    }

    public int getNavStatus() {
        return this.navStatus;
    }

    public void setNavStatus(int navStatus) {
        this.navStatus = navStatus;
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    public int getSog() {
        return this.sog;
    }

    public void setSog(int sog) {
        this.sog = sog;
    }

    public int getCog() {
        return this.cog;
    }

    public void setCog(int cog) {
        this.cog = cog;
    }

    public int getGnssPosStatus() {
        return this.gnssPosStatus;
    }

    public void setGnssPosStatus(int gnssPosStatus) {
        this.gnssPosStatus = gnssPosStatus;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString()).append(", ");
        builder.append("posAcc=").append(this.posAcc);
        builder.append(", raim=").append(this.raim);
        builder.append(", navStatus=").append(this.navStatus);
        builder.append(", pos=").append(this.pos);
        builder.append(", sog=").append(this.sog);
        builder.append(", cog=").append(this.cog);
        builder.append(", gnssPosStatus=").append(this.gnssPosStatus);
        builder.append(", spare=").append(this.spare);
        builder.append('}');
        return builder.toString();
    }
}

