/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPositionMessage;
import dk.dma.ais.sentence.Vdm;

public class AisMessage3
extends AisPositionMessage {
    private static final long serialVersionUID = 1L;
    private int slotIncrement;
    private int numSlots;
    private int keep;

    public AisMessage3() {
        super(3);
    }

    public AisMessage3(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        super.parse(binArray);
        this.slotIncrement = (int)binArray.getVal(13);
        this.numSlots = (int)binArray.getVal(3);
        this.keep = (int)binArray.getVal(1);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.slotIncrement, 13);
        encoder.addVal(this.numSlots, 3);
        encoder.addVal(this.keep, 1);
        return encoder;
    }

    public int getSlotIncrement() {
        return this.slotIncrement;
    }

    public int getNumSlots() {
        return this.numSlots;
    }

    public int getKeep() {
        return this.keep;
    }

    public void setSlotIncrement(int slotIncrement) {
        this.slotIncrement = slotIncrement;
    }

    public void setNumSlots(int numSlots) {
        this.numSlots = numSlots;
    }

    public void setKeep(int keep) {
        this.keep = keep;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", keep=");
        builder.append(this.keep);
        builder.append(", numSlots=");
        builder.append(this.numSlots);
        builder.append(", slotIncrement=");
        builder.append(this.slotIncrement);
        builder.append("]");
        return builder.toString();
    }
}

