/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisStaticCommon;
import dk.dma.ais.sentence.Vdm;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class AisMessage5
extends AisStaticCommon {
    private static final long serialVersionUID = 1L;
    int version;
    long imo;
    int posType;
    long eta;
    int draught;
    String dest;
    int dte;
    int spare;

    public AisMessage5() {
        super(5);
    }

    public AisMessage5(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() < 424) {
            throw new AisMessageException("Message 5 wrong length " + binArray.getLength());
        }
        super.parse(binArray);
        this.version = (int)binArray.getVal(2);
        this.imo = binArray.getVal(30);
        this.callsign = binArray.getString(7);
        this.name = binArray.getString(20);
        this.shipType = (int)binArray.getVal(8);
        this.dimBow = (int)binArray.getVal(9);
        this.dimStern = (int)binArray.getVal(9);
        this.dimPort = (int)binArray.getVal(6);
        this.dimStarboard = (int)binArray.getVal(6);
        this.posType = (int)binArray.getVal(4);
        this.eta = binArray.getVal(20);
        this.draught = (int)binArray.getVal(8);
        this.dest = binArray.getString(20);
        this.dte = (int)binArray.getVal(1);
        this.spare = (int)binArray.getVal(1);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.version, 2);
        encoder.addVal(this.imo, 30);
        encoder.addString(this.callsign, 7);
        encoder.addString(this.name, 20);
        encoder.addVal(this.shipType, 8);
        encoder.addVal(this.dimBow, 9);
        encoder.addVal(this.dimStern, 9);
        encoder.addVal(this.dimPort, 6);
        encoder.addVal(this.dimStarboard, 6);
        encoder.addVal(this.posType, 4);
        encoder.addVal(this.eta, 20);
        encoder.addVal(this.draught, 8);
        encoder.addString(this.dest, 20);
        encoder.addVal(this.dte, 1);
        encoder.addVal(this.spare, 1);
        return encoder;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public long getImo() {
        return this.imo;
    }

    public void setImo(long imo) {
        this.imo = imo;
    }

    public int getPosType() {
        return this.posType;
    }

    public void setPosType(int posType) {
        this.posType = posType;
    }

    public long getEta() {
        return this.eta;
    }

    public Date getEtaDate() {
        int min = (int)(this.eta & 0x3FL);
        int hour = (int)(this.eta & 0x7C0L) >> 6;
        int day = (int)(this.eta & 0xF800L) >> 11;
        int mon = (int)(this.eta & 0xF0000L) >> 16;
        if (min == 60 || hour == 24 || day == 0 || mon == 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
        cal.set(14, 0);
        cal.set(13, 0);
        cal.set(12, min);
        cal.set(11, hour);
        cal.set(5, day);
        cal.set(2, mon - 1);
        return cal.getTime();
    }

    public void setEta(long eta) {
        this.eta = eta;
    }

    public int getDraught() {
        return this.draught;
    }

    public void setDraught(int draught) {
        this.draught = draught;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public int getDte() {
        return this.dte;
    }

    public void setDte(int dte) {
        this.dte = dte;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", callsign=");
        builder.append(this.callsign);
        builder.append(", dest=");
        builder.append(this.dest);
        builder.append(", dimBow=");
        builder.append(this.dimBow);
        builder.append(", dimPort=");
        builder.append(this.dimPort);
        builder.append(", dimStarboard=");
        builder.append(this.dimStarboard);
        builder.append(", dimStern=");
        builder.append(this.dimStern);
        builder.append(", draught=");
        builder.append(this.draught);
        builder.append(", dte=");
        builder.append(this.dte);
        builder.append(", eta=");
        builder.append(this.eta);
        builder.append(", imo=");
        builder.append(this.imo);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", posType=");
        builder.append(this.posType);
        builder.append(", shipType=");
        builder.append(this.shipType);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", version=");
        builder.append(this.version);
        builder.append("]");
        return builder.toString();
    }
}

