/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisBinaryMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage6
extends AisBinaryMessage {
    private static final long serialVersionUID = 1L;
    private int seqNum;
    private long destination;
    private int retransmit;

    public AisMessage6() {
        super(6);
    }

    public AisMessage6(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() < 88 || sixbit.getLength() > 1008) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + sixbit.getLength());
        }
        super.parse(sixbit);
        this.seqNum = (int)sixbit.getVal(2);
        this.destination = sixbit.getVal(30);
        this.retransmit = (int)sixbit.getVal(1);
        this.spare = (int)sixbit.getVal(1);
        this.dac = (int)sixbit.getVal(10);
        this.fi = (int)sixbit.getVal(6);
        this.data = sixbit;
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.seqNum, 2);
        encoder.addVal(this.destination, 30);
        encoder.addVal(this.retransmit, 1);
        encoder.addVal(this.spare, 1);
        encoder.addVal(this.dac, 10);
        encoder.addVal(this.fi, 6);
        encoder.append(this.appMessage.getEncoded());
        return encoder;
    }

    public int getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(int seqNum) {
        this.seqNum = seqNum;
    }

    public long getDestination() {
        return this.destination;
    }

    public void setDestination(long destination) {
        this.destination = destination;
    }

    public int getRetransmit() {
        return this.retransmit;
    }

    public void setRetransmit(int retransmit) {
        this.retransmit = retransmit;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", destination=");
        builder.append(this.destination);
        builder.append(", retransmit=");
        builder.append(this.retransmit);
        builder.append(", seqNum=");
        builder.append(this.seqNum);
        builder.append("]");
        return builder.toString();
    }
}

