/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage7
extends AisMessage {
    private static final long serialVersionUID = 1L;
    private int spare;
    private long dest1;
    private int seq1;
    private long dest2;
    private int seq2;
    private long dest3;
    private int seq3;
    private long dest4;
    private int seq4;

    public AisMessage7() {
        super(7);
    }

    public AisMessage7(int num) {
        super(num);
    }

    public AisMessage7(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() < 72 || sixbit.getLength() > 168) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + sixbit.getLength());
        }
        super.parse(sixbit);
        this.spare = (int)sixbit.getVal(2);
        this.dest1 = sixbit.getVal(30);
        this.seq1 = (int)sixbit.getVal(2);
        if (!sixbit.hasMoreBits()) {
            return;
        }
        this.dest2 = sixbit.getVal(30);
        this.seq2 = (int)sixbit.getVal(2);
        if (!sixbit.hasMoreBits()) {
            return;
        }
        this.dest3 = sixbit.getVal(30);
        this.seq3 = (int)sixbit.getVal(2);
        if (!sixbit.hasMoreBits()) {
            return;
        }
        this.dest4 = sixbit.getVal(30);
        this.seq4 = (int)sixbit.getVal(2);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spare, 2);
        encoder.addVal(this.dest1, 30);
        encoder.addVal(this.seq1, 2);
        encoder.addVal(this.dest2, 30);
        encoder.addVal(this.seq2, 2);
        encoder.addVal(this.dest3, 30);
        encoder.addVal(this.seq3, 2);
        encoder.addVal(this.dest4, 30);
        encoder.addVal(this.seq4, 2);
        return encoder;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public long getDest1() {
        return this.dest1;
    }

    public void setDest1(long dest1) {
        this.dest1 = dest1;
    }

    public int getSeq1() {
        return this.seq1;
    }

    public void setSeq1(int seq1) {
        this.seq1 = seq1;
    }

    public long getDest2() {
        return this.dest2;
    }

    public void setDest2(long dest2) {
        this.dest2 = dest2;
    }

    public int getSeq2() {
        return this.seq2;
    }

    public void setSeq2(int seq2) {
        this.seq2 = seq2;
    }

    public long getDest3() {
        return this.dest3;
    }

    public void setDest3(long dest3) {
        this.dest3 = dest3;
    }

    public int getSeq3() {
        return this.seq3;
    }

    public void setSeq3(int seq3) {
        this.seq3 = seq3;
    }

    public long getDest4() {
        return this.dest4;
    }

    public void setDest4(long dest4) {
        this.dest4 = dest4;
    }

    public int getSeq4() {
        return this.seq4;
    }

    public void setSeq4(int seq4) {
        this.seq4 = seq4;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", dest1=");
        builder.append(this.dest1);
        builder.append(", seq1=");
        builder.append(this.seq1);
        builder.append(", dest2=");
        builder.append(this.dest2);
        builder.append(", seq2=");
        builder.append(this.seq2);
        builder.append(", dest3=");
        builder.append(this.dest3);
        builder.append(", seq3=");
        builder.append(this.seq3);
        builder.append(", dest4=");
        builder.append(this.dest4);
        builder.append(", seq4=");
        builder.append(this.seq4);
        builder.append("]");
        return builder.toString();
    }
}

