/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisBinaryMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.sentence.Vdm;

public class AisMessage8
extends AisBinaryMessage {
    private static final long serialVersionUID = 1L;

    public AisMessage8() {
        super(8);
    }

    public AisMessage8(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse();
    }

    public void parse() throws AisMessageException, SixbitException {
        BinArray binArray = this.vdm.getBinArray();
        if (binArray.getLength() < 56 || binArray.getLength() > 1008) {
            throw new AisMessageException("Message " + this.msgId + " wrong length: " + binArray.getLength());
        }
        super.parse(binArray);
        this.spare = (int)binArray.getVal(2);
        this.dac = (int)binArray.getVal(10);
        this.fi = (int)binArray.getVal(6);
        this.data = binArray;
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.spare, 2);
        encoder.addVal(this.dac, 10);
        encoder.addVal(this.fi, 6);
        encoder.append(this.appMessage.getEncoded());
        return encoder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }
}

