/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.ais.binary.BinArray;
import dk.dma.ais.binary.SixbitEncoder;
import dk.dma.ais.binary.SixbitException;
import dk.dma.ais.message.AisMessage;
import dk.dma.ais.message.AisMessageException;
import dk.dma.ais.message.AisPosition;
import dk.dma.ais.message.IPositionMessage;
import dk.dma.ais.sentence.Vdm;

public class AisMessage9
extends AisMessage
implements IPositionMessage {
    private static final long serialVersionUID = 1L;
    private int altitude;
    private int sog;
    private int posAcc;
    private AisPosition pos;
    private int cog;
    private int utcSec;
    private int regionalReserved;
    private int dte;
    private int spare;
    private int assigned;
    private int raim;
    private int commStateSelectorFlag;
    private int syncState;
    private int slotTimeout;
    private int subMessage;

    public AisMessage9() {
        super(9);
    }

    public AisMessage9(Vdm vdm) throws AisMessageException, SixbitException {
        super(vdm);
        this.parse(vdm.getBinArray());
    }

    @Override
    public void parse(BinArray binArray) throws AisMessageException, SixbitException {
        BinArray sixbit = this.vdm.getBinArray();
        if (sixbit.getLength() < 168) {
            throw new AisMessageException("Message 9 wrong length " + sixbit.getLength());
        }
        super.parse(binArray);
        this.altitude = (int)binArray.getVal(12);
        this.sog = (int)binArray.getVal(10);
        this.posAcc = (int)binArray.getVal(1);
        this.pos = new AisPosition();
        this.pos.setRawLongitude(binArray.getVal(28));
        this.pos.setRawLatitude(binArray.getVal(27));
        this.cog = (int)binArray.getVal(12);
        this.utcSec = (int)binArray.getVal(6);
        this.regionalReserved = (int)binArray.getVal(8);
        this.dte = (int)binArray.getVal(1);
        this.spare = (int)binArray.getVal(3);
        this.assigned = (int)binArray.getVal(1);
        this.raim = (int)binArray.getVal(1);
        this.commStateSelectorFlag = (int)binArray.getVal(1);
        this.syncState = (int)binArray.getVal(2);
        this.slotTimeout = (int)binArray.getVal(3);
        this.subMessage = (int)binArray.getVal(14);
    }

    @Override
    public SixbitEncoder getEncoded() {
        SixbitEncoder encoder = super.encode();
        encoder.addVal(this.altitude, 12);
        encoder.addVal(this.sog, 10);
        encoder.addVal(this.posAcc, 1);
        encoder.addVal(this.pos.getRawLongitude(), 28);
        encoder.addVal(this.pos.getRawLatitude(), 27);
        encoder.addVal(this.cog, 12);
        encoder.addVal(this.utcSec, 6);
        encoder.addVal(this.regionalReserved, 8);
        encoder.addVal(this.dte, 1);
        encoder.addVal(this.spare, 3);
        encoder.addVal(this.assigned, 1);
        encoder.addVal(this.raim, 1);
        encoder.addVal(this.commStateSelectorFlag, 1);
        encoder.addVal(this.syncState, 2);
        encoder.addVal(this.slotTimeout, 3);
        encoder.addVal(this.subMessage, 14);
        return encoder;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", altitude=");
        builder.append(this.altitude);
        builder.append(", sog=");
        builder.append(this.sog);
        builder.append(", posAcc=");
        builder.append(this.posAcc);
        builder.append(", pos=");
        builder.append(this.pos);
        builder.append(", cog=");
        builder.append(this.cog);
        builder.append(", utcSec=");
        builder.append(this.utcSec);
        builder.append(", regionalReserved=");
        builder.append(this.regionalReserved);
        builder.append(", dte=");
        builder.append(this.dte);
        builder.append(", spare=");
        builder.append(this.spare);
        builder.append(", assigned=");
        builder.append(this.assigned);
        builder.append(", raim=");
        builder.append(this.raim);
        builder.append(", commStateSelectorFlag=");
        builder.append(this.commStateSelectorFlag);
        builder.append(", syncState=");
        builder.append(this.syncState);
        builder.append(", slotTimeout=");
        builder.append(this.slotTimeout);
        builder.append(", subMessage=");
        builder.append(this.subMessage);
        builder.append("]");
        return builder.toString();
    }

    public int getAltitude() {
        return this.altitude;
    }

    public void setAltitude(int altitude) {
        this.altitude = altitude;
    }

    public int getSog() {
        return this.sog;
    }

    public void setSog(int sog) {
        this.sog = sog;
    }

    @Override
    public int getPosAcc() {
        return this.posAcc;
    }

    public void setPosAcc(int posAcc) {
        this.posAcc = posAcc;
    }

    @Override
    public AisPosition getPos() {
        return this.pos;
    }

    public void setPos(AisPosition pos) {
        this.pos = pos;
    }

    public int getCog() {
        return this.cog;
    }

    public void setCog(int cog) {
        this.cog = cog;
    }

    public int getUtcSec() {
        return this.utcSec;
    }

    public void setUtcSec(int utcSec) {
        this.utcSec = utcSec;
    }

    public int getRegionalReserved() {
        return this.regionalReserved;
    }

    public void setRegionalReserved(int regionalReserved) {
        this.regionalReserved = regionalReserved;
    }

    public int getDte() {
        return this.dte;
    }

    public void setDte(int dte) {
        this.dte = dte;
    }

    public int getSpare() {
        return this.spare;
    }

    public void setSpare(int spare) {
        this.spare = spare;
    }

    public int getAssigned() {
        return this.assigned;
    }

    public void setAssigned(int assigned) {
        this.assigned = assigned;
    }

    public int getRaim() {
        return this.raim;
    }

    public void setRaim(int raim) {
        this.raim = raim;
    }

    public int getCommStateSelectorFlag() {
        return this.commStateSelectorFlag;
    }

    public void setCommStateSelectorFlag(int commStateSelectorFlag) {
        this.commStateSelectorFlag = commStateSelectorFlag;
    }

    public int getSyncState() {
        return this.syncState;
    }

    public void setSyncState(int syncState) {
        this.syncState = syncState;
    }

    public int getSlotTimeout() {
        return this.slotTimeout;
    }

    public void setSlotTimeout(int slotTimeout) {
        this.slotTimeout = slotTimeout;
    }

    public int getSubMessage() {
        return this.subMessage;
    }

    public void setSubMessage(int subMessage) {
        this.subMessage = subMessage;
    }
}

