/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.ais.message;

import dk.dma.enav.model.geometry.Position;
import java.io.Serializable;

public class AisPosition
implements Serializable {
    private int bitCorrection;
    private long rawLatitude;
    private long rawLongitude;
    private double resolution = 10000.0;

    public AisPosition() {
    }

    public AisPosition(long rawLatitude, long rawLongitude) {
        this.rawLatitude = rawLatitude;
        this.rawLongitude = rawLongitude;
    }

    public AisPosition(Position location) {
        this.setLatitude(Math.round(location.getLatitude() * this.resolution * 60.0));
        this.setLongitude(Math.round(location.getLongitude() * this.resolution * 60.0));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        AisPosition pos2 = (AisPosition)obj;
        return pos2.rawLatitude == this.rawLatitude && pos2.rawLongitude == this.rawLongitude;
    }

    public Position getGeoLocation() {
        double lon;
        double lat = (double)this.getLatitude() / this.resolution / 60.0;
        if (Position.isValid((double)lat, (double)(lon = (double)this.getLongitude() / this.resolution / 60.0))) {
            return Position.create((double)lat, (double)lon);
        }
        return null;
    }

    public long getLatitude() {
        long latitude;
        if (this.rawLatitude >= (long)(0x4000000 >> this.bitCorrection)) {
            latitude = (long)(0x8000000 >> this.bitCorrection) - this.rawLatitude;
            latitude *= -1L;
        } else {
            latitude = this.rawLatitude;
        }
        return latitude;
    }

    public double getLatitudeDouble() {
        return (double)this.getLatitude() / this.resolution / 60.0;
    }

    public double getLongitudeDouble() {
        return (double)this.getLongitude() / this.resolution / 60.0;
    }

    public long getLongitude() {
        long longitude;
        if (this.rawLongitude >= (long)(0x8000000 >> this.bitCorrection)) {
            longitude = (long)(0x10000000 >> this.bitCorrection) - this.rawLongitude;
            longitude *= -1L;
        } else {
            longitude = this.rawLongitude;
        }
        return longitude;
    }

    public long getRawLatitude() {
        return this.rawLatitude;
    }

    public long getRawLongitude() {
        return this.rawLongitude;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bitCorrection;
        result = 31 * result + (int)(this.rawLatitude ^ this.rawLatitude >>> 32);
        result = 31 * result + (int)(this.rawLongitude ^ this.rawLongitude >>> 32);
        long temp = Double.doubleToLongBits(this.resolution);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public void set2524() {
        this.resolution = 1000.0;
        this.bitCorrection = 3;
    }

    public void set1817() {
        this.resolution = 10.0;
        this.bitCorrection = 10;
    }

    public void setLatitude(long latitude) {
        this.rawLatitude = latitude < 0L ? latitude + (long)(0x8000000 >> this.bitCorrection) : latitude;
    }

    public void setLongitude(long longitude) {
        this.rawLongitude = longitude < 0L ? longitude + (long)(0x10000000 >> this.bitCorrection) : longitude;
    }

    public void setRawLatitude(long rawLatitude) {
        this.rawLatitude = rawLatitude;
    }

    public void setRawLongitude(long rawLongitude) {
        this.rawLongitude = rawLongitude;
    }

    public String toString() {
        return "(" + this.getRawLatitude() + "," + this.getRawLongitude() + ") = (" + this.getLatitude() + "," + this.getLongitude() + ")";
    }
}

